/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.configuration.configresolvers;

import com.javonet.sdk.configuration.Config;
import com.javonet.sdk.configuration.ConfigPriority;
import com.javonet.sdk.configuration.ConfigsDictionary;
import com.javonet.sdk.configuration.configresolvers.ConfigResolver;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.UtilsConst;
import com.javonet.utils.connectiondata.IConnectionData;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigResolver
extends ConfigResolver {
    public static void addConfigs(ConfigPriority priority, String yamlString) {
        Map<String, Object> rootMap = YamlConfigResolver.getObjectMap(yamlString);
        YamlConfigResolver.setLicenseKey(rootMap);
        Object configurationsObj = rootMap.get("configurations");
        if (!(configurationsObj instanceof Map)) {
            throw new IllegalArgumentException("YAML must contain 'configurations' mapping.");
        }
        Map configurations = (Map)configurationsObj;
        for (Map.Entry entry : configurations.entrySet()) {
            String configName = (String)entry.getKey();
            Object configValue = entry.getValue();
            if (configName == null || configName.trim().isEmpty()) {
                System.out.println("Skipping entry with empty config name.");
                continue;
            }
            if (!(configValue instanceof Map)) {
                System.out.println("Skipping '" + configName + "': value is not a mapping.");
                continue;
            }
            try {
                Map configMap = (Map)configValue;
                String runtimeValue = YamlConfigResolver.getRequiredString(configMap, "runtime");
                RuntimeName runtimeName = YamlConfigResolver.tryParseRuntime(runtimeValue);
                String host = YamlConfigResolver.getOptionalString(configMap, "host");
                IConnectionData connectionData = YamlConfigResolver.buildConnectionData(host);
                String plugins = YamlConfigResolver.getOptionalString(configMap, "plugins");
                String modules = YamlConfigResolver.getOptionalString(configMap, "modules");
                Config config = new Config(runtimeName, connectionData, plugins, modules);
                ConfigsDictionary.addConfig(configName, priority, config);
            }
            catch (Exception ex) {
                System.out.println("Failed to add config '" + configName + "': " + ex.getMessage());
            }
        }
    }

    @NotNull
    private static Map<String, Object> getObjectMap(String yamlString) {
        Object data;
        if (yamlString == null || yamlString.trim().isEmpty()) {
            throw new IllegalArgumentException("YAML string cannot be null or empty.");
        }
        Yaml yaml = new Yaml();
        try {
            data = yaml.load(yamlString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse YAML: " + e.getMessage(), e);
        }
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("Root YAML node must be a mapping (object).");
        }
        Map rootMap = (Map)data;
        return rootMap;
    }

    private static void setLicenseKey(Map<String, Object> rootMap) {
        Object licenseKeyObj = rootMap.get("licenseKey");
        if (licenseKeyObj instanceof String) {
            UtilsConst.setLicenseKey(((String)licenseKeyObj).trim());
        }
    }

    private static String getRequiredString(Map<String, Object> mapping, String key) {
        Object value = mapping.get(key);
        if (!(value instanceof String) || ((String)value).trim().isEmpty()) {
            throw new IllegalArgumentException("Missing or invalid '" + key + "' property.");
        }
        return ((String)value).trim();
    }

    private static String getOptionalString(Map<String, Object> mapping, String key) {
        Object value = mapping.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }
}

