/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.javonet.utils.UtilsConst;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class ActivationHelper {
    public static String getLicenseKey() {
        try {
            return ActivationHelper.getLicenseKeyFromFile();
        }
        catch (Exception e) {
            return UtilsConst.getLicenseKey();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getLicenseKeyFromFile() throws Exception {
        String filePath = UtilsConst.getJavonetWorkingDirectory() + "javonet.lic";
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException("License file not found.");
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject jsonObject = JsonParser.parseReader(reader).getAsJsonObject();
            JsonObject activateResult = jsonObject.getAsJsonObject("ActivateResult");
            if (activateResult == null) {
                throw new IllegalStateException("ActivateResult element not found in the JSON response.");
            }
            JsonObject innerDoc = JsonParser.parseString(activateResult.get("Value").getAsString()).getAsJsonObject();
            JsonElement licenseKeyElement = innerDoc.get("licenceKey");
            if (licenseKeyElement == null) {
                throw new IllegalStateException("License key not found in the ActivateResult.");
            }
            String string = licenseKeyElement.getAsString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

