/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.tools;

import com.javonet.sdk.InvocationContext;
import com.javonet.sdk.tools.TypeParsingFunctions.JavaTypeParsingFunctions;
import com.javonet.sdk.tools.TypeParsingFunctions.NetcoreTypeParsingFunctions;
import com.javonet.sdk.tools.TypeParsingFunctions.NodejsTypeParsingFunctions;
import com.javonet.sdk.tools.TypeParsingFunctions.PythonTypeParsingFunctions;
import com.javonet.utils.RuntimeName;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class ComplexTypeResolver {
    private static final Map<String, ActivatorDetails> TYPE_MAP = new HashMap<String, ActivatorDetails>();
    private static final Map<RuntimeName, Map<String, Function<InvocationContext, Object>>> TYPE_PARSING_FUNCTIONS = new EnumMap<RuntimeName, Map<String, Function<InvocationContext, Object>>>(RuntimeName.class);
    public static final ComplexTypeResolver INSTANCE;

    private ComplexTypeResolver() {
    }

    public void register(String resultType, Class<?> clazz, Object[] args2) {
        TYPE_MAP.computeIfAbsent(resultType, k -> new ActivatorDetails(clazz, args2));
    }

    public static Object convertResult(InvocationContext ic) {
        Function<InvocationContext, Object> parsingFn;
        Map<String, Function<InvocationContext, Object>> runtimeMap = TYPE_PARSING_FUNCTIONS.get((Object)ic.getRuntimeName());
        if (runtimeMap != null && (parsingFn = runtimeMap.get(ic.getResultType())) != null) {
            return parsingFn.apply(ic);
        }
        ActivatorDetails details = TYPE_MAP.get(ic.getResultType());
        if (details == null) {
            throw new IllegalArgumentException("No type registered for key '" + ic.getResultType() + "'.");
        }
        return ComplexTypeResolver.createInstance(details.type, details.arguments);
    }

    private static Object createInstance(Class<?> clazz, Object[] args2) {
        try {
            if (args2.length == 0) {
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                Class<?>[] paramTypes = ctor.getParameterTypes();
                if (paramTypes.length != args2.length) continue;
                boolean compatible = true;
                for (int i = 0; i < paramTypes.length && compatible; ++i) {
                    compatible = ComplexTypeResolver.isAssignable(paramTypes[i], args2[i].getClass());
                }
                if (!compatible) continue;
                return ctor.newInstance(args2);
            }
            throw new NoSuchMethodException("No matching constructor found for " + clazz.getName());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create instance of " + clazz.getName(), e);
        }
    }

    private static boolean isAssignable(Class<?> paramType, Class<?> argType) {
        if (paramType.isAssignableFrom(argType)) {
            return true;
        }
        if (paramType.isPrimitive()) {
            return paramType == Boolean.TYPE && argType == Boolean.class || paramType == Byte.TYPE && argType == Byte.class || paramType == Short.TYPE && argType == Short.class || paramType == Integer.TYPE && argType == Integer.class || paramType == Long.TYPE && argType == Long.class || paramType == Float.TYPE && argType == Float.class || paramType == Double.TYPE && argType == Double.class || paramType == Character.TYPE && argType == Character.class;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class<?> resolveType(String className, String jar) {
        try {
            if (jar == null) return Class.forName(className);
            if (jar.trim().isEmpty()) return Class.forName(className);
            Path path = Paths.get(jar, new String[0]).toAbsolutePath();
            URL jarUrl = path.toUri().toURL();
            try (URLClassLoader cl = new URLClassLoader(new URL[]{jarUrl}, ComplexTypeResolver.class.getClassLoader());){
                Class<?> clazz = Class.forName(className, true, cl);
                return clazz;
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to resolve type: " + className, ex);
        }
    }

    static {
        TYPE_PARSING_FUNCTIONS.put(RuntimeName.Jvm, JavaTypeParsingFunctions.PARSING_FUNCTIONS);
        TYPE_PARSING_FUNCTIONS.put(RuntimeName.Python, PythonTypeParsingFunctions.PARSING_FUNCTIONS);
        TYPE_PARSING_FUNCTIONS.put(RuntimeName.Nodejs, NodejsTypeParsingFunctions.PARSING_FUNCTIONS);
        TYPE_PARSING_FUNCTIONS.put(RuntimeName.Netcore, NetcoreTypeParsingFunctions.PARSING_FUNCTIONS);
        INSTANCE = new ComplexTypeResolver();
    }

    private static final class ActivatorDetails {
        final Class<?> type;
        final Object[] arguments;

        ActivatorDetails(Class<?> type, Object[] arguments) {
            this.type = Objects.requireNonNull(type, "type");
            this.arguments = arguments == null ? new Object[]{} : (Object[])arguments.clone();
        }
    }
}

