/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeName;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class Command {
    private final RuntimeName runtimeName;
    private final CommandType commandType;
    private final Object[] payload;

    public Command(RuntimeName runtimeName, CommandType commandType, Object ... payload) {
        this.runtimeName = runtimeName;
        this.commandType = commandType;
        this.payload = payload != null ? payload : new Object[]{};
    }

    public Command(RuntimeName runtimeName, CommandType commandType, Object payload) {
        this.runtimeName = runtimeName;
        this.commandType = commandType;
        this.payload = Command.normalizePayload(payload);
    }

    private static Object[] normalizePayload(Object payload) {
        if (payload == null) {
            return new Object[]{null};
        }
        if (payload instanceof Object[]) {
            return (Object[])payload;
        }
        Class<?> clazz = payload.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(payload);
            Object[] result = new Object[len];
            for (int i = 0; i < len; ++i) {
                result[i] = Array.get(payload, i);
            }
            return result;
        }
        return new Object[]{payload};
    }

    public int getPayloadSize() {
        return this.payload.length;
    }

    public String toString() {
        try {
            StringBuilder result = new StringBuilder("RuntimeName ");
            result.append((Object)this.runtimeName);
            result.append(" ");
            result.append("CommandType ");
            result.append((Object)this.commandType);
            result.append(" ");
            result.append("Payload ");
            for (int i = 0; i < this.payload.length; ++i) {
                if (this.payload[i] == null) {
                    result.append("null");
                } else {
                    result.append(this.payload[i]);
                }
                if (i >= this.payload.length - 1) continue;
                result.append(" ");
            }
            return result.toString();
        }
        catch (Exception ex) {
            return "Error while converting command to string: " + ex.getMessage();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command that = (Command)o;
        return this.runtimeName == that.runtimeName && this.commandType == that.commandType && Arrays.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return 31 * (Objects.hash(new Object[]{this.runtimeName, this.commandType}) + Arrays.hashCode(this.getHashablePayload()));
    }

    private Object[] getHashablePayload() {
        switch (this.commandType) {
            case VALUE: 
            case LOAD_LIBRARY: 
            case CREATE_INSTANCE: 
            case GET_TYPE: {
                return new Object[]{this.payload[0]};
            }
            case GET_STATIC_FIELD: 
            case SET_STATIC_FIELD: 
            case GET_MODULE: 
            case INVOKE_STATIC_METHOD: 
            case INVOKE_INSTANCE_METHOD: {
                return new Object[]{this.payload[0], this.payload[1]};
            }
        }
        throw new RuntimeException((Object)((Object)this.commandType) + " payload size not implemented");
    }

    public RuntimeName getRuntimeName() {
        return this.runtimeName;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public Object[] getPayload() {
        return this.payload;
    }

    public Command dropFirstPayloadArg() {
        if (this.payload.length <= 1) {
            return new Command(this.runtimeName, this.commandType, new Object[0]);
        }
        int newLength = this.payload.length - 1;
        Object[] newPayload = new Object[newLength];
        System.arraycopy(this.payload, 1, newPayload, 0, newLength);
        return new Command(this.runtimeName, this.commandType, newPayload);
    }

    public Command addArgToPayload(Object arg) {
        int oldLength = this.payload.length;
        Object[] newPayload = new Object[oldLength + 1];
        if (oldLength > 0) {
            System.arraycopy(this.payload, 0, newPayload, 0, oldLength);
        }
        newPayload[oldLength] = arg;
        return new Command(this.runtimeName, this.commandType, newPayload);
    }

    public Command prependArgToPayload(Object argCommand) {
        if (argCommand == null) {
            return this;
        }
        int oldLength = this.payload.length;
        Object[] newPayload = new Object[oldLength + 1];
        newPayload[0] = argCommand;
        if (oldLength > 0) {
            System.arraycopy(this.payload, 0, newPayload, 1, oldLength);
        }
        return new Command(this.runtimeName, this.commandType, newPayload);
    }

    public static Command createResponse(Object response, RuntimeName runtimeName) {
        return new Command(runtimeName, CommandType.VALUE, response);
    }

    public static Command createReference(String guid, RuntimeName runtimeName) {
        return new Command(runtimeName, CommandType.REFERENCE, (Object)guid);
    }

    public static Command createArrayResponse(Object array, RuntimeName runtimeName) {
        return new Command(runtimeName, CommandType.ARRAY, array);
    }
}

