/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class HandlerUtils {
    private static final Map<Class<?>, Class<?>> wrapperToPrimitiveMap = new HashMap();

    public static Class<?>[] getArgumentTypesAsBoxed(Object[] arguments) {
        return HandlerUtils.mapArgumentTypes(arguments, false);
    }

    public static Class<?>[] getArgumentTypesAsPrimitives(Object[] arguments) {
        return HandlerUtils.mapArgumentTypes(arguments, true);
    }

    public static Object[] convertArgumentsToPrimitives(Object[] arguments) {
        Object[] convertedArguments = new Object[arguments.length];
        Class<?>[] argumentTypesAsPrimitives = HandlerUtils.getArgumentTypesAsPrimitives(arguments);
        for (int i = 0; i < arguments.length; ++i) {
            Class<?> targetType = argumentTypesAsPrimitives[i];
            Object sourceArgument = arguments[i];
            if (sourceArgument != null && targetType.isArray() && targetType.getComponentType().isPrimitive() && !targetType.equals(sourceArgument.getClass())) {
                Object[] sourceArray = (Object[])sourceArgument;
                int length = sourceArray.length;
                Object primitiveArray = Array.newInstance(targetType.getComponentType(), length);
                for (int j = 0; j < length; ++j) {
                    Array.set(primitiveArray, j, sourceArray[j]);
                }
                convertedArguments[i] = primitiveArray;
                continue;
            }
            convertedArguments[i] = sourceArgument;
        }
        return convertedArguments;
    }

    private static Class<?>[] mapArgumentTypes(Object[] arguments, boolean toPrimitive) {
        Class[] argumentTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                argumentTypes[i] = Object.class;
                continue;
            }
            Class<?> classType = arguments[i].getClass();
            argumentTypes[i] = HandlerUtils.mapType(classType, toPrimitive);
        }
        return argumentTypes;
    }

    public static Class<?> mapType(Class<?> classType, boolean toPrimitive) {
        if (!toPrimitive) {
            return classType;
        }
        if (classType.isArray()) {
            Class<?> componentType = classType.getComponentType();
            Class<?> primitiveComponentType = wrapperToPrimitiveMap.get(componentType);
            if (primitiveComponentType != null) {
                return Array.newInstance(primitiveComponentType, 0).getClass();
            }
            return classType;
        }
        return wrapperToPrimitiveMap.getOrDefault(classType, classType);
    }

    static {
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
    }
}

