/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import com.javonet.utils.RuntimeName;

public class RuntimeNameHandler {
    public static String getName(RuntimeName runtimeName) {
        switch (runtimeName) {
            case Clr: {
                return "clr";
            }
            case Go: {
                return "go";
            }
            case Jvm: {
                return "jvm";
            }
            case Netcore: {
                return "netcore";
            }
            case Perl: {
                return "perl";
            }
            case Python: {
                return "python";
            }
            case Ruby: {
                return "ruby";
            }
            case Nodejs: {
                return "nodejs";
            }
            case Cpp: {
                return "cpp";
            }
            case Php: {
                return "php";
            }
            case Python27: {
                return "python27";
            }
            case NONE: {
                return "none";
            }
        }
        return "none";
    }

    public static RuntimeName getRuntimeName(String runtime) {
        String rt;
        if (runtime == null || runtime.trim().isEmpty()) {
            throw new IllegalArgumentException("Runtime string cannot be null or whitespace.");
        }
        switch (rt = runtime.trim().toLowerCase()) {
            case "clr": {
                return RuntimeName.Clr;
            }
            case "go": {
                return RuntimeName.Go;
            }
            case "jvm": {
                return RuntimeName.Jvm;
            }
            case "netcore": {
                return RuntimeName.Netcore;
            }
            case "perl": {
                return RuntimeName.Perl;
            }
            case "python": {
                return RuntimeName.Python;
            }
            case "ruby": {
                return RuntimeName.Ruby;
            }
            case "nodejs": {
                return RuntimeName.Nodejs;
            }
            case "cpp": {
                return RuntimeName.Cpp;
            }
            case "php": {
                return RuntimeName.Php;
            }
            case "python27": {
                return RuntimeName.Python27;
            }
            case "none": {
                return RuntimeName.NONE;
            }
        }
        throw new IllegalArgumentException("Unknown runtime: " + runtime);
    }
}

