/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils.exceptions;

import com.javonet.utils.Command;
import com.javonet.utils.ExceptionType;
import com.javonet.utils.exceptions.UncheckedFileNotFoundException;
import com.javonet.utils.exceptions.UncheckedIOException;
import com.javonet.utils.messagehelper.MessageHelper;

public class ExceptionThrower {
    public static void throwException(Command commandException) {
        try {
            StackTraceElement[] stackTrace = null;
            String exceptionMessage = "Java Exception with empty message";
            String exceptionName = "Java Exception";
            String javonetStackCommand = "";
            ExceptionType exceptionType = ExceptionType.EXCEPTION;
            switch (commandException.getPayload().length) {
                case 8: {
                    stackTrace = ExceptionThrower.getLocalStackTrace((String)commandException.getPayload()[4], (String)commandException.getPayload()[5], (String)commandException.getPayload()[6], (String)commandException.getPayload()[7]);
                }
                case 4: {
                    exceptionMessage = (String)commandException.getPayload()[3];
                }
                case 3: {
                    exceptionName = (String)commandException.getPayload()[2];
                }
                case 2: {
                    javonetStackCommand = (String)commandException.getPayload()[1];
                }
                case 1: {
                    exceptionType = ExceptionType.values()[(Integer)commandException.getPayload()[0]];
                    break;
                }
                default: {
                    throw new RuntimeException("Error while processing exception: " + commandException.toString());
                }
            }
            if (stackTrace == null) {
                stackTrace = new StackTraceElement[]{new StackTraceElement("", "", "", 0)};
            }
            switch (exceptionType) {
                case EXCEPTION: 
                case RUNTIME_EXCEPTION: {
                    RuntimeException runtimeException = new RuntimeException(exceptionMessage);
                    runtimeException.setStackTrace(stackTrace);
                    throw runtimeException;
                }
                case IO_EXCEPTION: {
                    UncheckedIOException uncheckedIOException = new UncheckedIOException(exceptionMessage);
                    uncheckedIOException.setStackTrace(stackTrace);
                    throw uncheckedIOException;
                }
                case ARITHMETIC_EXCEPTION: 
                case DIVIDE_BY_ZERO_EXCEPTION: {
                    ArithmeticException arithmeticException = new ArithmeticException(exceptionMessage);
                    arithmeticException.setStackTrace(stackTrace);
                    throw arithmeticException;
                }
                case NULL_POINTER_EXCEPTION: {
                    NullPointerException nullPointerException = new NullPointerException(exceptionMessage);
                    nullPointerException.setStackTrace(stackTrace);
                    throw nullPointerException;
                }
                case FILE_NOT_FOUND_EXCEPTION: {
                    UncheckedFileNotFoundException uncheckedFileNotFoundException = new UncheckedFileNotFoundException(exceptionMessage);
                    uncheckedFileNotFoundException.setStackTrace(stackTrace);
                    throw uncheckedFileNotFoundException;
                }
                case ILLEGAL_ARGUMENT_EXCEPTION: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exceptionMessage);
                    illegalArgumentException.setStackTrace(stackTrace);
                    throw illegalArgumentException;
                }
                case INDEX_OUT_OF_BOUNDS_EXCEPTION: {
                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException(exceptionMessage);
                    indexOutOfBoundsException.setStackTrace(stackTrace);
                    throw indexOutOfBoundsException;
                }
            }
            throw new RuntimeException("Error while processing exception: " + commandException.toString());
        }
        catch (Exception ex) {
            MessageHelper.getInstance().sendMessageToAppInsights("SdkException", ex.getMessage());
            throw ex;
        }
    }

    private static StackTraceElement[] getLocalStackTrace(String stackTraceClasses, String stackTraceMethods, String stackTraceLines, String stackTraceFiles) {
        String[] stackClasses = stackTraceClasses.split("\\|");
        String[] stackMethods = stackTraceMethods.split("\\|");
        String[] stackLines = stackTraceLines.split("\\|");
        String[] stackFiles = stackTraceFiles.split("\\|");
        StackTraceElement[] result = new StackTraceElement[stackLines.length];
        for (int i = 0; i < stackLines.length; ++i) {
            StackTraceElement ste;
            int stackLine = 0;
            try {
                stackLine = Integer.parseInt(stackLines[i]);
            }
            catch (NumberFormatException ex) {
                stackLine = 0;
            }
            result[i] = ste = new StackTraceElement(stackClasses[i], stackMethods[i], stackFiles[i], stackLine);
        }
        return result;
    }
}

