from javonet.core.handler.AbstractHandler import AbstractHandler
from javonet.core.handler.ValueHandler import ValueHandler
from javonet.core.handler.LoadLibraryHandler import LoadLibraryHandler
from javonet.core.handler.InvokeStaticMethodHandler import InvokeStaticMethodHandler
from javonet.core.handler.GetStaticFieldHandler import GetStaticFieldHandler
from javonet.core.handler.SetStaticFieldHandler import SetStaticFieldHandler
from javonet.core.handler.CreateClassInstanceHandler import CreateClassInstanceHandler
from javonet.core.handler.GetTypeHandler import GetTypeHandler
from javonet.core.handler.ResolveInstanceHandler import ResolveInstanceHandler
from javonet.core.handler.GetModuleHandler import GetModuleHandler
from javonet.core.handler.InvokeInstanceMethodHandler import InvokeInstanceMethodHandler
from javonet.core.handler.ExceptionHandler import ExceptionHandler
from javonet.core.handler.HeartBeatHandler import HeartBeatHandler
from javonet.core.handler.CastingHandler import CastingHandler
from javonet.core.handler.GetInstanceFieldHandler import GetInstanceFieldHandler
from javonet.core.handler.OptimizeHandler import OptimizeHandler
from javonet.core.handler.GenerateLibHandler import GenerateLibHandler
from javonet.core.handler.InvokeGlobalFunctionHandler import InvokeGlobalFunctionHandler
from javonet.core.handler.DestructReferenceHandler import DestructReferenceHandler
from javonet.core.handler.ArrayReferenceHandler import ArrayReferenceHandler
from javonet.core.handler.ArrayGetItemHandler import ArrayGetItemHandler
from javonet.core.handler.ArrayGetSizeHandler import ArrayGetSizeHandler
from javonet.core.handler.ArrayGetRankHandler import ArrayGetRankHandler
from javonet.core.handler.ArraySetItemHandler import ArraySetItemHandler
from javonet.core.handler.ArrayHandler import ArrayHandler
from javonet.core.handler.RetrieveArrayHandler import RetrieveArrayHandler
from javonet.core.handler.SetInstanceFieldHandler import SetInstanceFieldHandler
from javonet.core.handler.InvokeGenericStaticMethodHandler import InvokeGenericStaticMethodHandler
from javonet.core.handler.InvokeGenericMethodHandler import InvokeGenericMethodHandler
from javonet.core.handler.GetEnumItemHandler import GetEnumItemHandler
from javonet.core.handler.GetEnumNameHandler import GetEnumNameHandler
from javonet.core.handler.GetEnumValueHandler import GetEnumValueHandler
from javonet.core.handler.AsRefHandler import AsRefHandler
from javonet.core.handler.AsOutHandler import AsOutHandler
from javonet.core.handler.GetRefValueHandler import GetRefValueHandler
from javonet.core.handler.EnableNamespaceHandler import EnableNamespaceHandler
from javonet.core.handler.EnableTypeHandler import EnableTypeHandler
from javonet.core.handler.CreateNullHandler import CreateNullHandler
from javonet.core.handler.GetStaticMethodAsDelegateHandler import GetStaticMethodAsDelegateHandler
from javonet.core.handler.GetInstanceMethodAsDelegateHandler import GetInstanceMethodAsDelegateHandler
from javonet.core.handler.PassDelegateHandler import PassDelegateHandler
from javonet.core.handler.InvokeDelegateHandler import InvokeDelegateHandler
from javonet.core.handler.ConvertTypeHandler import ConvertTypeHandler
from javonet.core.handler.AddEventListenerHandler import AddEventListenerHandler
from javonet.core.handler.PluginWrapperHandler import PluginWrapperHandler
from javonet.core.handler.GetAsyncOperationResultHandler import GetAsyncOperationResultHandler
from javonet.core.handler.GetKwargHandler import GetKwargHandler
from javonet.core.handler.GetResultTypeHandler import GetResultTypeHandler
from javonet.core.handler.GetGlobalFieldHandler import GetGlobalFieldHandler
from javonet.core.handler.RegisterForUpdateHandler import RegisterForUpdateHandler
from javonet.core.handler.ValueForUpdateHandler import ValueForUpdateHandler


from javonet.core.handler.HandlerDictionary import handler_dict
from javonet.core.referenceCache.ReferencesCache import ReferencesCache
from javonet.utils.TypesHandler import TypesHandler
from javonet.utils.exception.ExceptionSerializer import ExceptionSerializer
from javonet.utils.CommandType import CommandType
from javonet.utils.Command import Command


class Handler(AbstractHandler):
    _initialized = False

    @staticmethod
    def _initialize():
        """Initialize the handler dictionary. Should be called once."""
        if not Handler._initialized:
            handler_dict[CommandType.Value] = ValueHandler()
            handler_dict[CommandType.LoadLibrary] = LoadLibraryHandler()
            handler_dict[CommandType.InvokeStaticMethod] = InvokeStaticMethodHandler()
            handler_dict[CommandType.GetStaticField] = GetStaticFieldHandler()
            handler_dict[CommandType.SetStaticField] = SetStaticFieldHandler()
            handler_dict[CommandType.CreateClassInstance] = CreateClassInstanceHandler()
            handler_dict[CommandType.GetType] = GetTypeHandler()
            handler_dict[CommandType.Reference] = ResolveInstanceHandler()
            handler_dict[CommandType.GetModule] = GetModuleHandler()
            handler_dict[CommandType.InvokeInstanceMethod] = InvokeInstanceMethodHandler()
            handler_dict[CommandType.Exception] = ExceptionHandler()
            handler_dict[CommandType.HeartBeat] = HeartBeatHandler()
            handler_dict[CommandType.Cast] = CastingHandler()
            handler_dict[CommandType.GetInstanceField] = GetInstanceFieldHandler()
            handler_dict[CommandType.Optimize] = OptimizeHandler()
            handler_dict[CommandType.GenerateLib] = GenerateLibHandler()
            handler_dict[CommandType.InvokeGlobalFunction] = InvokeGlobalFunctionHandler()
            handler_dict[CommandType.DestructReference] = DestructReferenceHandler()
            handler_dict[CommandType.ArrayReference] = ArrayReferenceHandler()
            handler_dict[CommandType.ArrayGetItem] = ArrayGetItemHandler()
            handler_dict[CommandType.ArrayGetSize] = ArrayGetSizeHandler()
            handler_dict[CommandType.ArrayGetRank] = ArrayGetRankHandler()
            handler_dict[CommandType.ArraySetItem] = ArraySetItemHandler()
            handler_dict[CommandType.Array] = ArrayHandler()
            handler_dict[CommandType.RetrieveArray] = RetrieveArrayHandler()
            handler_dict[CommandType.SetInstanceField] = SetInstanceFieldHandler()
            handler_dict[CommandType.InvokeGenericStaticMethod] = InvokeGenericStaticMethodHandler()
            handler_dict[CommandType.InvokeGenericMethod] = InvokeGenericMethodHandler()
            handler_dict[CommandType.GetEnumItem] = GetEnumItemHandler()
            handler_dict[CommandType.GetEnumName] = GetEnumNameHandler()
            handler_dict[CommandType.GetEnumValue] = GetEnumValueHandler()
            handler_dict[CommandType.AsRef] = AsRefHandler()
            handler_dict[CommandType.AsOut] = AsOutHandler()
            handler_dict[CommandType.GetRefValue] = GetRefValueHandler()
            handler_dict[CommandType.EnableNamespace] = EnableNamespaceHandler()
            handler_dict[CommandType.EnableType] = EnableTypeHandler()
            handler_dict[CommandType.CreateNull] = CreateNullHandler()
            handler_dict[CommandType.GetStaticMethodAsDelegate] = GetStaticMethodAsDelegateHandler()
            handler_dict[CommandType.GetInstanceMethodAsDelegate] = GetInstanceMethodAsDelegateHandler()
            handler_dict[CommandType.PassDelegate] = PassDelegateHandler()
            handler_dict[CommandType.InvokeDelegate] = InvokeDelegateHandler()
            handler_dict[CommandType.ConvertType] = ConvertTypeHandler()
            handler_dict[CommandType.AddEventListener] = AddEventListenerHandler()
            handler_dict[CommandType.PluginWrapper] = PluginWrapperHandler()
            handler_dict[CommandType.GetAsyncOperationResult] = GetAsyncOperationResultHandler()
            handler_dict[CommandType.AsKwargs] = GetKwargHandler()
            handler_dict[CommandType.GetResultType] = GetResultTypeHandler()
            handler_dict[CommandType.GetGlobalField] = GetGlobalFieldHandler()
            handler_dict[CommandType.RegisterForUpdate] = RegisterForUpdateHandler()
            handler_dict[CommandType.ValueForUpdate] = ValueForUpdateHandler()
            Handler._initialized = True

    def __init__(self):
        """Initialize Handler instance and set up handler dictionary if not already done."""
        Handler._initialize()

    @staticmethod
    def handle_command(command):
        """
        Handle a command by routing it to the appropriate handler.

        Args:
            command: The command to handle.

        Returns:
            Command: The response command.
        """
        Handler._initialize()
        try:
            if command.command_type == CommandType.RetrieveArray:
                response_array = handler_dict[CommandType.Reference].handle_command(command.payload[0])
                return Command.create_array_response(response_array, command.runtime_name)

            # Preprocess PluginWrapper before routing to specific handler
            if command.command_type == CommandType.PluginWrapper:
                command = PluginWrapperHandler().handle_command(command)

            response = handler_dict.get(command.command_type).handle_command(command)
            parsed = Handler.__parse_response(response, command.runtime_name)

            # Append ValueForUpdate commands from RegisterForUpdateHandler contexts
            contexts = RegisterForUpdateHandler._invocation_contexts.map
            if contexts and len(contexts) > 0:
                for guid, instance in list(contexts.items()):
                    instance_guid = ReferencesCache().cache_reference(instance)
                    update_cmd = Command(
                        command.runtime_name,
                        CommandType.ValueForUpdate,
                        [str(guid) if guid is not None else "",
                        instance_guid]
                    )
                    parsed = parsed.add_arg_to_payload(update_cmd)
                # Clear all entries after processing this request
                contexts.clear()

            return parsed
        except Exception as e:
            return ExceptionSerializer.serialize_exception(e, command)

    @staticmethod
    def __parse_response(response, runtime_name):
        if TypesHandler.is_primitive_or_none(response):
            return Command.create_response(response, runtime_name)
        else:
            guid = ReferencesCache().cache_reference(response)
            return Command.create_reference(guid, runtime_name)

    @staticmethod
    def __is_response_array(response):
        return isinstance(response, list)
