/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AiFoundryProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#ai_services_hub_id AiFoundryProject#ai_services_hub_id}
    */
    readonly aiServicesHubId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#description AiFoundryProject#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#friendly_name AiFoundryProject#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#high_business_impact_enabled AiFoundryProject#high_business_impact_enabled}
    */
    readonly highBusinessImpactEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#id AiFoundryProject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#location AiFoundryProject#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#name AiFoundryProject#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#primary_user_assigned_identity AiFoundryProject#primary_user_assigned_identity}
    */
    readonly primaryUserAssignedIdentity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#tags AiFoundryProject#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#identity AiFoundryProject#identity}
    */
    readonly identity?: AiFoundryProjectIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#timeouts AiFoundryProject#timeouts}
    */
    readonly timeouts?: AiFoundryProjectTimeouts;
}
export interface AiFoundryProjectIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#identity_ids AiFoundryProject#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#type AiFoundryProject#type}
    */
    readonly type: string;
}
export declare function aiFoundryProjectIdentityToTerraform(struct?: AiFoundryProjectIdentityOutputReference | AiFoundryProjectIdentity): any;
export declare function aiFoundryProjectIdentityToHclTerraform(struct?: AiFoundryProjectIdentityOutputReference | AiFoundryProjectIdentity): any;
export declare class AiFoundryProjectIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiFoundryProjectIdentity | undefined;
    set internalValue(value: AiFoundryProjectIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface AiFoundryProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#create AiFoundryProject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#delete AiFoundryProject#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#read AiFoundryProject#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#update AiFoundryProject#update}
    */
    readonly update?: string;
}
export declare function aiFoundryProjectTimeoutsToTerraform(struct?: AiFoundryProjectTimeouts | cdktf.IResolvable): any;
export declare function aiFoundryProjectTimeoutsToHclTerraform(struct?: AiFoundryProjectTimeouts | cdktf.IResolvable): any;
export declare class AiFoundryProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AiFoundryProjectTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AiFoundryProjectTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project azurerm_ai_foundry_project}
*/
export declare class AiFoundryProject extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_ai_foundry_project";
    /**
    * Generates CDKTF code for importing a AiFoundryProject resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AiFoundryProject to import
    * @param importFromId The id of the existing AiFoundryProject that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AiFoundryProject to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/ai_foundry_project azurerm_ai_foundry_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AiFoundryProjectConfig
    */
    constructor(scope: Construct, id: string, config: AiFoundryProjectConfig);
    private _aiServicesHubId?;
    get aiServicesHubId(): string;
    set aiServicesHubId(value: string);
    get aiServicesHubIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _highBusinessImpactEnabled?;
    get highBusinessImpactEnabled(): boolean | cdktf.IResolvable;
    set highBusinessImpactEnabled(value: boolean | cdktf.IResolvable);
    resetHighBusinessImpactEnabled(): void;
    get highBusinessImpactEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryUserAssignedIdentity?;
    get primaryUserAssignedIdentity(): string;
    set primaryUserAssignedIdentity(value: string);
    resetPrimaryUserAssignedIdentity(): void;
    get primaryUserAssignedIdentityInput(): string | undefined;
    get projectId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): AiFoundryProjectIdentityOutputReference;
    putIdentity(value: AiFoundryProjectIdentity): void;
    resetIdentity(): void;
    get identityInput(): AiFoundryProjectIdentity | undefined;
    private _timeouts;
    get timeouts(): AiFoundryProjectTimeoutsOutputReference;
    putTimeouts(value: AiFoundryProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AiFoundryProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
