/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#api_management_id ApiManagementCustomDomain#api_management_id}
    */
    readonly apiManagementId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#id ApiManagementCustomDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * developer_portal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#developer_portal ApiManagementCustomDomain#developer_portal}
    */
    readonly developerPortal?: ApiManagementCustomDomainDeveloperPortal[] | cdktf.IResolvable;
    /**
    * gateway block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#gateway ApiManagementCustomDomain#gateway}
    */
    readonly gateway?: ApiManagementCustomDomainGateway[] | cdktf.IResolvable;
    /**
    * management block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#management ApiManagementCustomDomain#management}
    */
    readonly management?: ApiManagementCustomDomainManagement[] | cdktf.IResolvable;
    /**
    * portal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#portal ApiManagementCustomDomain#portal}
    */
    readonly portal?: ApiManagementCustomDomainPortal[] | cdktf.IResolvable;
    /**
    * scm block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#scm ApiManagementCustomDomain#scm}
    */
    readonly scm?: ApiManagementCustomDomainScm[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#timeouts ApiManagementCustomDomain#timeouts}
    */
    readonly timeouts?: ApiManagementCustomDomainTimeouts;
}
export interface ApiManagementCustomDomainDeveloperPortal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_certificate_id ApiManagementCustomDomain#key_vault_certificate_id}
    */
    readonly keyVaultCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainDeveloperPortalToTerraform(struct?: ApiManagementCustomDomainDeveloperPortal | cdktf.IResolvable): any;
export declare function apiManagementCustomDomainDeveloperPortalToHclTerraform(struct?: ApiManagementCustomDomainDeveloperPortal | cdktf.IResolvable): any;
export declare class ApiManagementCustomDomainDeveloperPortalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementCustomDomainDeveloperPortal | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementCustomDomainDeveloperPortal | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultCertificateId?;
    get keyVaultCertificateId(): string;
    set keyVaultCertificateId(value: string);
    resetKeyVaultCertificateId(): void;
    get keyVaultCertificateIdInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementCustomDomainDeveloperPortalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementCustomDomainDeveloperPortal[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementCustomDomainDeveloperPortalOutputReference;
}
export interface ApiManagementCustomDomainGateway {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#default_ssl_binding ApiManagementCustomDomain#default_ssl_binding}
    */
    readonly defaultSslBinding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_certificate_id ApiManagementCustomDomain#key_vault_certificate_id}
    */
    readonly keyVaultCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainGatewayToTerraform(struct?: ApiManagementCustomDomainGateway | cdktf.IResolvable): any;
export declare function apiManagementCustomDomainGatewayToHclTerraform(struct?: ApiManagementCustomDomainGateway | cdktf.IResolvable): any;
export declare class ApiManagementCustomDomainGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementCustomDomainGateway | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementCustomDomainGateway | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    private _defaultSslBinding?;
    get defaultSslBinding(): boolean | cdktf.IResolvable;
    set defaultSslBinding(value: boolean | cdktf.IResolvable);
    resetDefaultSslBinding(): void;
    get defaultSslBindingInput(): boolean | cdktf.IResolvable | undefined;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultCertificateId?;
    get keyVaultCertificateId(): string;
    set keyVaultCertificateId(value: string);
    resetKeyVaultCertificateId(): void;
    get keyVaultCertificateIdInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementCustomDomainGatewayList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementCustomDomainGateway[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementCustomDomainGatewayOutputReference;
}
export interface ApiManagementCustomDomainManagement {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_certificate_id ApiManagementCustomDomain#key_vault_certificate_id}
    */
    readonly keyVaultCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainManagementToTerraform(struct?: ApiManagementCustomDomainManagement | cdktf.IResolvable): any;
export declare function apiManagementCustomDomainManagementToHclTerraform(struct?: ApiManagementCustomDomainManagement | cdktf.IResolvable): any;
export declare class ApiManagementCustomDomainManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementCustomDomainManagement | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementCustomDomainManagement | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultCertificateId?;
    get keyVaultCertificateId(): string;
    set keyVaultCertificateId(value: string);
    resetKeyVaultCertificateId(): void;
    get keyVaultCertificateIdInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementCustomDomainManagementList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementCustomDomainManagement[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementCustomDomainManagementOutputReference;
}
export interface ApiManagementCustomDomainPortal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_certificate_id ApiManagementCustomDomain#key_vault_certificate_id}
    */
    readonly keyVaultCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainPortalToTerraform(struct?: ApiManagementCustomDomainPortal | cdktf.IResolvable): any;
export declare function apiManagementCustomDomainPortalToHclTerraform(struct?: ApiManagementCustomDomainPortal | cdktf.IResolvable): any;
export declare class ApiManagementCustomDomainPortalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementCustomDomainPortal | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementCustomDomainPortal | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultCertificateId?;
    get keyVaultCertificateId(): string;
    set keyVaultCertificateId(value: string);
    resetKeyVaultCertificateId(): void;
    get keyVaultCertificateIdInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementCustomDomainPortalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementCustomDomainPortal[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementCustomDomainPortalOutputReference;
}
export interface ApiManagementCustomDomainScm {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate ApiManagementCustomDomain#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#certificate_password ApiManagementCustomDomain#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#host_name ApiManagementCustomDomain#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_certificate_id ApiManagementCustomDomain#key_vault_certificate_id}
    */
    readonly keyVaultCertificateId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#key_vault_id ApiManagementCustomDomain#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#negotiate_client_certificate ApiManagementCustomDomain#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#ssl_keyvault_identity_client_id ApiManagementCustomDomain#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementCustomDomainScmToTerraform(struct?: ApiManagementCustomDomainScm | cdktf.IResolvable): any;
export declare function apiManagementCustomDomainScmToHclTerraform(struct?: ApiManagementCustomDomainScm | cdktf.IResolvable): any;
export declare class ApiManagementCustomDomainScmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementCustomDomainScm | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementCustomDomainScm | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultCertificateId?;
    get keyVaultCertificateId(): string;
    set keyVaultCertificateId(value: string);
    resetKeyVaultCertificateId(): void;
    get keyVaultCertificateIdInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementCustomDomainScmList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementCustomDomainScm[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementCustomDomainScmOutputReference;
}
export interface ApiManagementCustomDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#create ApiManagementCustomDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#delete ApiManagementCustomDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#read ApiManagementCustomDomain#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#update ApiManagementCustomDomain#update}
    */
    readonly update?: string;
}
export declare function apiManagementCustomDomainTimeoutsToTerraform(struct?: ApiManagementCustomDomainTimeouts | cdktf.IResolvable): any;
export declare function apiManagementCustomDomainTimeoutsToHclTerraform(struct?: ApiManagementCustomDomainTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementCustomDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementCustomDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain azurerm_api_management_custom_domain}
*/
export declare class ApiManagementCustomDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_custom_domain";
    /**
    * Generates CDKTF code for importing a ApiManagementCustomDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementCustomDomain to import
    * @param importFromId The id of the existing ApiManagementCustomDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementCustomDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_custom_domain azurerm_api_management_custom_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementCustomDomainConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementCustomDomainConfig);
    private _apiManagementId?;
    get apiManagementId(): string;
    set apiManagementId(value: string);
    get apiManagementIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _developerPortal;
    get developerPortal(): ApiManagementCustomDomainDeveloperPortalList;
    putDeveloperPortal(value: ApiManagementCustomDomainDeveloperPortal[] | cdktf.IResolvable): void;
    resetDeveloperPortal(): void;
    get developerPortalInput(): cdktf.IResolvable | ApiManagementCustomDomainDeveloperPortal[] | undefined;
    private _gateway;
    get gateway(): ApiManagementCustomDomainGatewayList;
    putGateway(value: ApiManagementCustomDomainGateway[] | cdktf.IResolvable): void;
    resetGateway(): void;
    get gatewayInput(): cdktf.IResolvable | ApiManagementCustomDomainGateway[] | undefined;
    private _management;
    get management(): ApiManagementCustomDomainManagementList;
    putManagement(value: ApiManagementCustomDomainManagement[] | cdktf.IResolvable): void;
    resetManagement(): void;
    get managementInput(): cdktf.IResolvable | ApiManagementCustomDomainManagement[] | undefined;
    private _portal;
    get portal(): ApiManagementCustomDomainPortalList;
    putPortal(value: ApiManagementCustomDomainPortal[] | cdktf.IResolvable): void;
    resetPortal(): void;
    get portalInput(): cdktf.IResolvable | ApiManagementCustomDomainPortal[] | undefined;
    private _scm;
    get scm(): ApiManagementCustomDomainScmList;
    putScm(value: ApiManagementCustomDomainScm[] | cdktf.IResolvable): void;
    resetScm(): void;
    get scmInput(): cdktf.IResolvable | ApiManagementCustomDomainScm[] | undefined;
    private _timeouts;
    get timeouts(): ApiManagementCustomDomainTimeoutsOutputReference;
    putTimeouts(value: ApiManagementCustomDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementCustomDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
