/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementRedisCacheConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#api_management_id ApiManagementRedisCache#api_management_id}
    */
    readonly apiManagementId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#cache_location ApiManagementRedisCache#cache_location}
    */
    readonly cacheLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#connection_string ApiManagementRedisCache#connection_string}
    */
    readonly connectionString: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#description ApiManagementRedisCache#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#id ApiManagementRedisCache#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#name ApiManagementRedisCache#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#redis_cache_id ApiManagementRedisCache#redis_cache_id}
    */
    readonly redisCacheId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#timeouts ApiManagementRedisCache#timeouts}
    */
    readonly timeouts?: ApiManagementRedisCacheTimeouts;
}
export interface ApiManagementRedisCacheTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#create ApiManagementRedisCache#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#delete ApiManagementRedisCache#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#read ApiManagementRedisCache#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#update ApiManagementRedisCache#update}
    */
    readonly update?: string;
}
export declare function apiManagementRedisCacheTimeoutsToTerraform(struct?: ApiManagementRedisCacheTimeouts | cdktf.IResolvable): any;
export declare function apiManagementRedisCacheTimeoutsToHclTerraform(struct?: ApiManagementRedisCacheTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementRedisCacheTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementRedisCacheTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementRedisCacheTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache azurerm_api_management_redis_cache}
*/
export declare class ApiManagementRedisCache extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_redis_cache";
    /**
    * Generates CDKTF code for importing a ApiManagementRedisCache resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementRedisCache to import
    * @param importFromId The id of the existing ApiManagementRedisCache that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementRedisCache to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_redis_cache azurerm_api_management_redis_cache} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementRedisCacheConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementRedisCacheConfig);
    private _apiManagementId?;
    get apiManagementId(): string;
    set apiManagementId(value: string);
    get apiManagementIdInput(): string | undefined;
    private _cacheLocation?;
    get cacheLocation(): string;
    set cacheLocation(value: string);
    resetCacheLocation(): void;
    get cacheLocationInput(): string | undefined;
    private _connectionString?;
    get connectionString(): string;
    set connectionString(value: string);
    get connectionStringInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redisCacheId?;
    get redisCacheId(): string;
    set redisCacheId(value: string);
    resetRedisCacheId(): void;
    get redisCacheIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementRedisCacheTimeoutsOutputReference;
    putTimeouts(value: ApiManagementRedisCacheTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementRedisCacheTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
