/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementStandaloneGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#backend_subnet_id ApiManagementStandaloneGateway#backend_subnet_id}
    */
    readonly backendSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#id ApiManagementStandaloneGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#location ApiManagementStandaloneGateway#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#name ApiManagementStandaloneGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#resource_group_name ApiManagementStandaloneGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#tags ApiManagementStandaloneGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#virtual_network_type ApiManagementStandaloneGateway#virtual_network_type}
    */
    readonly virtualNetworkType?: string;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#sku ApiManagementStandaloneGateway#sku}
    */
    readonly sku: ApiManagementStandaloneGatewaySku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#timeouts ApiManagementStandaloneGateway#timeouts}
    */
    readonly timeouts?: ApiManagementStandaloneGatewayTimeouts;
}
export interface ApiManagementStandaloneGatewaySku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#capacity ApiManagementStandaloneGateway#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#name ApiManagementStandaloneGateway#name}
    */
    readonly name: string;
}
export declare function apiManagementStandaloneGatewaySkuToTerraform(struct?: ApiManagementStandaloneGatewaySkuOutputReference | ApiManagementStandaloneGatewaySku): any;
export declare function apiManagementStandaloneGatewaySkuToHclTerraform(struct?: ApiManagementStandaloneGatewaySkuOutputReference | ApiManagementStandaloneGatewaySku): any;
export declare class ApiManagementStandaloneGatewaySkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementStandaloneGatewaySku | undefined;
    set internalValue(value: ApiManagementStandaloneGatewaySku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface ApiManagementStandaloneGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#create ApiManagementStandaloneGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#delete ApiManagementStandaloneGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#read ApiManagementStandaloneGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#update ApiManagementStandaloneGateway#update}
    */
    readonly update?: string;
}
export declare function apiManagementStandaloneGatewayTimeoutsToTerraform(struct?: ApiManagementStandaloneGatewayTimeouts | cdktf.IResolvable): any;
export declare function apiManagementStandaloneGatewayTimeoutsToHclTerraform(struct?: ApiManagementStandaloneGatewayTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementStandaloneGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementStandaloneGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementStandaloneGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway azurerm_api_management_standalone_gateway}
*/
export declare class ApiManagementStandaloneGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_standalone_gateway";
    /**
    * Generates CDKTF code for importing a ApiManagementStandaloneGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementStandaloneGateway to import
    * @param importFromId The id of the existing ApiManagementStandaloneGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementStandaloneGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/api_management_standalone_gateway azurerm_api_management_standalone_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementStandaloneGatewayConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementStandaloneGatewayConfig);
    private _backendSubnetId?;
    get backendSubnetId(): string;
    set backendSubnetId(value: string);
    resetBackendSubnetId(): void;
    get backendSubnetIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkType?;
    get virtualNetworkType(): string;
    set virtualNetworkType(value: string);
    resetVirtualNetworkType(): void;
    get virtualNetworkTypeInput(): string | undefined;
    private _sku;
    get sku(): ApiManagementStandaloneGatewaySkuOutputReference;
    putSku(value: ApiManagementStandaloneGatewaySku): void;
    get skuInput(): ApiManagementStandaloneGatewaySku | undefined;
    private _timeouts;
    get timeouts(): ApiManagementStandaloneGatewayTimeoutsOutputReference;
    putTimeouts(value: ApiManagementStandaloneGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementStandaloneGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
