/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#app_service_plan_id AppServiceCertificate#app_service_plan_id}
    */
    readonly appServicePlanId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#id AppServiceCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#key_vault_id AppServiceCertificate#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#key_vault_secret_id AppServiceCertificate#key_vault_secret_id}
    */
    readonly keyVaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#location AppServiceCertificate#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#name AppServiceCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#password AppServiceCertificate#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#pfx_blob AppServiceCertificate#pfx_blob}
    */
    readonly pfxBlob?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#resource_group_name AppServiceCertificate#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#tags AppServiceCertificate#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#timeouts AppServiceCertificate#timeouts}
    */
    readonly timeouts?: AppServiceCertificateTimeouts;
}
export interface AppServiceCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#create AppServiceCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#delete AppServiceCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#read AppServiceCertificate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#update AppServiceCertificate#update}
    */
    readonly update?: string;
}
export declare function appServiceCertificateTimeoutsToTerraform(struct?: AppServiceCertificateTimeouts | cdktf.IResolvable): any;
export declare function appServiceCertificateTimeoutsToHclTerraform(struct?: AppServiceCertificateTimeouts | cdktf.IResolvable): any;
export declare class AppServiceCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceCertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate azurerm_app_service_certificate}
*/
export declare class AppServiceCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_certificate";
    /**
    * Generates CDKTF code for importing a AppServiceCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceCertificate to import
    * @param importFromId The id of the existing AppServiceCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/app_service_certificate azurerm_app_service_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceCertificateConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceCertificateConfig);
    private _appServicePlanId?;
    get appServicePlanId(): string;
    set appServicePlanId(value: string);
    resetAppServicePlanId(): void;
    get appServicePlanIdInput(): string | undefined;
    get expirationDate(): string;
    get friendlyName(): string;
    get hostNames(): string[];
    get hostingEnvironmentProfileId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issueDate(): string;
    get issuer(): string;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _keyVaultSecretId?;
    get keyVaultSecretId(): string;
    set keyVaultSecretId(value: string);
    resetKeyVaultSecretId(): void;
    get keyVaultSecretIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _pfxBlob?;
    get pfxBlob(): string;
    set pfxBlob(value: string);
    resetPfxBlob(): void;
    get pfxBlobInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get subjectName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get thumbprint(): string;
    private _timeouts;
    get timeouts(): AppServiceCertificateTimeoutsOutputReference;
    putTimeouts(value: AppServiceCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
