/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationLoadBalancerFrontendConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#application_load_balancer_id ApplicationLoadBalancerFrontend#application_load_balancer_id}
    */
    readonly applicationLoadBalancerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#id ApplicationLoadBalancerFrontend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#name ApplicationLoadBalancerFrontend#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#tags ApplicationLoadBalancerFrontend#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#timeouts ApplicationLoadBalancerFrontend#timeouts}
    */
    readonly timeouts?: ApplicationLoadBalancerFrontendTimeouts;
}
export interface ApplicationLoadBalancerFrontendTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#create ApplicationLoadBalancerFrontend#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#delete ApplicationLoadBalancerFrontend#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#read ApplicationLoadBalancerFrontend#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#update ApplicationLoadBalancerFrontend#update}
    */
    readonly update?: string;
}
export declare function applicationLoadBalancerFrontendTimeoutsToTerraform(struct?: ApplicationLoadBalancerFrontendTimeouts | cdktf.IResolvable): any;
export declare function applicationLoadBalancerFrontendTimeoutsToHclTerraform(struct?: ApplicationLoadBalancerFrontendTimeouts | cdktf.IResolvable): any;
export declare class ApplicationLoadBalancerFrontendTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationLoadBalancerFrontendTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationLoadBalancerFrontendTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend azurerm_application_load_balancer_frontend}
*/
export declare class ApplicationLoadBalancerFrontend extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_application_load_balancer_frontend";
    /**
    * Generates CDKTF code for importing a ApplicationLoadBalancerFrontend resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApplicationLoadBalancerFrontend to import
    * @param importFromId The id of the existing ApplicationLoadBalancerFrontend that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApplicationLoadBalancerFrontend to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/application_load_balancer_frontend azurerm_application_load_balancer_frontend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationLoadBalancerFrontendConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationLoadBalancerFrontendConfig);
    private _applicationLoadBalancerId?;
    get applicationLoadBalancerId(): string;
    set applicationLoadBalancerId(value: string);
    get applicationLoadBalancerIdInput(): string | undefined;
    get fullyQualifiedDomainName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): ApplicationLoadBalancerFrontendTimeoutsOutputReference;
    putTimeouts(value: ApplicationLoadBalancerFrontendTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApplicationLoadBalancerFrontendTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
