/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ArcKubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#agent_public_key_certificate ArcKubernetesCluster#agent_public_key_certificate}
    */
    readonly agentPublicKeyCertificate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#id ArcKubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#location ArcKubernetesCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#name ArcKubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#resource_group_name ArcKubernetesCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#tags ArcKubernetesCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#identity ArcKubernetesCluster#identity}
    */
    readonly identity: ArcKubernetesClusterIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#timeouts ArcKubernetesCluster#timeouts}
    */
    readonly timeouts?: ArcKubernetesClusterTimeouts;
}
export interface ArcKubernetesClusterIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#type ArcKubernetesCluster#type}
    */
    readonly type: string;
}
export declare function arcKubernetesClusterIdentityToTerraform(struct?: ArcKubernetesClusterIdentityOutputReference | ArcKubernetesClusterIdentity): any;
export declare function arcKubernetesClusterIdentityToHclTerraform(struct?: ArcKubernetesClusterIdentityOutputReference | ArcKubernetesClusterIdentity): any;
export declare class ArcKubernetesClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesClusterIdentity | undefined;
    set internalValue(value: ArcKubernetesClusterIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ArcKubernetesClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#create ArcKubernetesCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#delete ArcKubernetesCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#read ArcKubernetesCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#update ArcKubernetesCluster#update}
    */
    readonly update?: string;
}
export declare function arcKubernetesClusterTimeoutsToTerraform(struct?: ArcKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare function arcKubernetesClusterTimeoutsToHclTerraform(struct?: ArcKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare class ArcKubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ArcKubernetesClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ArcKubernetesClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster azurerm_arc_kubernetes_cluster}
*/
export declare class ArcKubernetesCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_arc_kubernetes_cluster";
    /**
    * Generates CDKTF code for importing a ArcKubernetesCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ArcKubernetesCluster to import
    * @param importFromId The id of the existing ArcKubernetesCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ArcKubernetesCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/arc_kubernetes_cluster azurerm_arc_kubernetes_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ArcKubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: ArcKubernetesClusterConfig);
    private _agentPublicKeyCertificate?;
    get agentPublicKeyCertificate(): string;
    set agentPublicKeyCertificate(value: string);
    get agentPublicKeyCertificateInput(): string | undefined;
    get agentVersion(): string;
    get distribution(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get infrastructure(): string;
    get kubernetesVersion(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get offering(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get totalCoreCount(): number;
    get totalNodeCount(): number;
    private _identity;
    get identity(): ArcKubernetesClusterIdentityOutputReference;
    putIdentity(value: ArcKubernetesClusterIdentity): void;
    get identityInput(): ArcKubernetesClusterIdentity | undefined;
    private _timeouts;
    get timeouts(): ArcKubernetesClusterTimeoutsOutputReference;
    putTimeouts(value: ArcKubernetesClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ArcKubernetesClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
