/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#id CdnFrontdoorProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#name CdnFrontdoorProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#resource_group_name CdnFrontdoorProfile#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#response_timeout_seconds CdnFrontdoorProfile#response_timeout_seconds}
    */
    readonly responseTimeoutSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#sku_name CdnFrontdoorProfile#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#tags CdnFrontdoorProfile#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#identity CdnFrontdoorProfile#identity}
    */
    readonly identity?: CdnFrontdoorProfileIdentity;
    /**
    * log_scrubbing_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#log_scrubbing_rule CdnFrontdoorProfile#log_scrubbing_rule}
    */
    readonly logScrubbingRule?: CdnFrontdoorProfileLogScrubbingRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#timeouts CdnFrontdoorProfile#timeouts}
    */
    readonly timeouts?: CdnFrontdoorProfileTimeouts;
}
export interface CdnFrontdoorProfileIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#identity_ids CdnFrontdoorProfile#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#type CdnFrontdoorProfile#type}
    */
    readonly type: string;
}
export declare function cdnFrontdoorProfileIdentityToTerraform(struct?: CdnFrontdoorProfileIdentityOutputReference | CdnFrontdoorProfileIdentity): any;
export declare function cdnFrontdoorProfileIdentityToHclTerraform(struct?: CdnFrontdoorProfileIdentityOutputReference | CdnFrontdoorProfileIdentity): any;
export declare class CdnFrontdoorProfileIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorProfileIdentity | undefined;
    set internalValue(value: CdnFrontdoorProfileIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface CdnFrontdoorProfileLogScrubbingRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#match_variable CdnFrontdoorProfile#match_variable}
    */
    readonly matchVariable: string;
}
export declare function cdnFrontdoorProfileLogScrubbingRuleToTerraform(struct?: CdnFrontdoorProfileLogScrubbingRule | cdktf.IResolvable): any;
export declare function cdnFrontdoorProfileLogScrubbingRuleToHclTerraform(struct?: CdnFrontdoorProfileLogScrubbingRule | cdktf.IResolvable): any;
export declare class CdnFrontdoorProfileLogScrubbingRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorProfileLogScrubbingRule | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorProfileLogScrubbingRule | cdktf.IResolvable | undefined);
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
}
export declare class CdnFrontdoorProfileLogScrubbingRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorProfileLogScrubbingRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorProfileLogScrubbingRuleOutputReference;
}
export interface CdnFrontdoorProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#create CdnFrontdoorProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#delete CdnFrontdoorProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#read CdnFrontdoorProfile#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#update CdnFrontdoorProfile#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorProfileTimeoutsToTerraform(struct?: CdnFrontdoorProfileTimeouts | cdktf.IResolvable): any;
export declare function cdnFrontdoorProfileTimeoutsToHclTerraform(struct?: CdnFrontdoorProfileTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorProfileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile azurerm_cdn_frontdoor_profile}
*/
export declare class CdnFrontdoorProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_profile";
    /**
    * Generates CDKTF code for importing a CdnFrontdoorProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnFrontdoorProfile to import
    * @param importFromId The id of the existing CdnFrontdoorProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnFrontdoorProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_profile azurerm_cdn_frontdoor_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorProfileConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorProfileConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get resourceGuid(): string;
    private _responseTimeoutSeconds?;
    get responseTimeoutSeconds(): number;
    set responseTimeoutSeconds(value: number);
    resetResponseTimeoutSeconds(): void;
    get responseTimeoutSecondsInput(): number | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): CdnFrontdoorProfileIdentityOutputReference;
    putIdentity(value: CdnFrontdoorProfileIdentity): void;
    resetIdentity(): void;
    get identityInput(): CdnFrontdoorProfileIdentity | undefined;
    private _logScrubbingRule;
    get logScrubbingRule(): CdnFrontdoorProfileLogScrubbingRuleList;
    putLogScrubbingRule(value: CdnFrontdoorProfileLogScrubbingRule[] | cdktf.IResolvable): void;
    resetLogScrubbingRule(): void;
    get logScrubbingRuleInput(): cdktf.IResolvable | CdnFrontdoorProfileLogScrubbingRule[] | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorProfileTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
