/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorSecurityPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#cdn_frontdoor_profile_id CdnFrontdoorSecurityPolicy#cdn_frontdoor_profile_id}
    */
    readonly cdnFrontdoorProfileId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#id CdnFrontdoorSecurityPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#name CdnFrontdoorSecurityPolicy#name}
    */
    readonly name: string;
    /**
    * security_policies block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#security_policies CdnFrontdoorSecurityPolicy#security_policies}
    */
    readonly securityPolicies: CdnFrontdoorSecurityPolicySecurityPolicies;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#timeouts CdnFrontdoorSecurityPolicy#timeouts}
    */
    readonly timeouts?: CdnFrontdoorSecurityPolicyTimeouts;
}
export interface CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomain {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#cdn_frontdoor_domain_id CdnFrontdoorSecurityPolicy#cdn_frontdoor_domain_id}
    */
    readonly cdnFrontdoorDomainId: string;
}
export declare function cdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomainToTerraform(struct?: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomain | cdktf.IResolvable): any;
export declare function cdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomainToHclTerraform(struct?: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomain | cdktf.IResolvable): any;
export declare class CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomain | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomain | cdktf.IResolvable | undefined);
    get active(): cdktf.IResolvable;
    private _cdnFrontdoorDomainId?;
    get cdnFrontdoorDomainId(): string;
    set cdnFrontdoorDomainId(value: string);
    get cdnFrontdoorDomainIdInput(): string | undefined;
}
export declare class CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomainList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomain[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomainOutputReference;
}
export interface CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#patterns_to_match CdnFrontdoorSecurityPolicy#patterns_to_match}
    */
    readonly patternsToMatch: string[];
    /**
    * domain block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#domain CdnFrontdoorSecurityPolicy#domain}
    */
    readonly domain: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomain[] | cdktf.IResolvable;
}
export declare function cdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationToTerraform(struct?: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationOutputReference | CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociation): any;
export declare function cdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationToHclTerraform(struct?: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationOutputReference | CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociation): any;
export declare class CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociation | undefined;
    set internalValue(value: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociation | undefined);
    private _patternsToMatch?;
    get patternsToMatch(): string[];
    set patternsToMatch(value: string[]);
    get patternsToMatchInput(): string[] | undefined;
    private _domain;
    get domain(): CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomainList;
    putDomain(value: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomain[] | cdktf.IResolvable): void;
    get domainInput(): cdktf.IResolvable | CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationDomain[] | undefined;
}
export interface CdnFrontdoorSecurityPolicySecurityPoliciesFirewall {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#cdn_frontdoor_firewall_policy_id CdnFrontdoorSecurityPolicy#cdn_frontdoor_firewall_policy_id}
    */
    readonly cdnFrontdoorFirewallPolicyId: string;
    /**
    * association block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#association CdnFrontdoorSecurityPolicy#association}
    */
    readonly association: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociation;
}
export declare function cdnFrontdoorSecurityPolicySecurityPoliciesFirewallToTerraform(struct?: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallOutputReference | CdnFrontdoorSecurityPolicySecurityPoliciesFirewall): any;
export declare function cdnFrontdoorSecurityPolicySecurityPoliciesFirewallToHclTerraform(struct?: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallOutputReference | CdnFrontdoorSecurityPolicySecurityPoliciesFirewall): any;
export declare class CdnFrontdoorSecurityPolicySecurityPoliciesFirewallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorSecurityPolicySecurityPoliciesFirewall | undefined;
    set internalValue(value: CdnFrontdoorSecurityPolicySecurityPoliciesFirewall | undefined);
    private _cdnFrontdoorFirewallPolicyId?;
    get cdnFrontdoorFirewallPolicyId(): string;
    set cdnFrontdoorFirewallPolicyId(value: string);
    get cdnFrontdoorFirewallPolicyIdInput(): string | undefined;
    private _association;
    get association(): CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociationOutputReference;
    putAssociation(value: CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociation): void;
    get associationInput(): CdnFrontdoorSecurityPolicySecurityPoliciesFirewallAssociation | undefined;
}
export interface CdnFrontdoorSecurityPolicySecurityPolicies {
    /**
    * firewall block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#firewall CdnFrontdoorSecurityPolicy#firewall}
    */
    readonly firewall: CdnFrontdoorSecurityPolicySecurityPoliciesFirewall;
}
export declare function cdnFrontdoorSecurityPolicySecurityPoliciesToTerraform(struct?: CdnFrontdoorSecurityPolicySecurityPoliciesOutputReference | CdnFrontdoorSecurityPolicySecurityPolicies): any;
export declare function cdnFrontdoorSecurityPolicySecurityPoliciesToHclTerraform(struct?: CdnFrontdoorSecurityPolicySecurityPoliciesOutputReference | CdnFrontdoorSecurityPolicySecurityPolicies): any;
export declare class CdnFrontdoorSecurityPolicySecurityPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorSecurityPolicySecurityPolicies | undefined;
    set internalValue(value: CdnFrontdoorSecurityPolicySecurityPolicies | undefined);
    private _firewall;
    get firewall(): CdnFrontdoorSecurityPolicySecurityPoliciesFirewallOutputReference;
    putFirewall(value: CdnFrontdoorSecurityPolicySecurityPoliciesFirewall): void;
    get firewallInput(): CdnFrontdoorSecurityPolicySecurityPoliciesFirewall | undefined;
}
export interface CdnFrontdoorSecurityPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#create CdnFrontdoorSecurityPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#delete CdnFrontdoorSecurityPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#read CdnFrontdoorSecurityPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#update CdnFrontdoorSecurityPolicy#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorSecurityPolicyTimeoutsToTerraform(struct?: CdnFrontdoorSecurityPolicyTimeouts | cdktf.IResolvable): any;
export declare function cdnFrontdoorSecurityPolicyTimeoutsToHclTerraform(struct?: CdnFrontdoorSecurityPolicyTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorSecurityPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorSecurityPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorSecurityPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy azurerm_cdn_frontdoor_security_policy}
*/
export declare class CdnFrontdoorSecurityPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_security_policy";
    /**
    * Generates CDKTF code for importing a CdnFrontdoorSecurityPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnFrontdoorSecurityPolicy to import
    * @param importFromId The id of the existing CdnFrontdoorSecurityPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnFrontdoorSecurityPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cdn_frontdoor_security_policy azurerm_cdn_frontdoor_security_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorSecurityPolicyConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorSecurityPolicyConfig);
    private _cdnFrontdoorProfileId?;
    get cdnFrontdoorProfileId(): string;
    set cdnFrontdoorProfileId(value: string);
    get cdnFrontdoorProfileIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _securityPolicies;
    get securityPolicies(): CdnFrontdoorSecurityPolicySecurityPoliciesOutputReference;
    putSecurityPolicies(value: CdnFrontdoorSecurityPolicySecurityPolicies): void;
    get securityPoliciesInput(): CdnFrontdoorSecurityPolicySecurityPolicies | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorSecurityPolicyTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorSecurityPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorSecurityPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
