/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConsumptionBudgetResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#amount ConsumptionBudgetResourceGroup#amount}
    */
    readonly amount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#etag ConsumptionBudgetResourceGroup#etag}
    */
    readonly etag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#id ConsumptionBudgetResourceGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#resource_group_id ConsumptionBudgetResourceGroup#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#time_grain ConsumptionBudgetResourceGroup#time_grain}
    */
    readonly timeGrain?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#filter ConsumptionBudgetResourceGroup#filter}
    */
    readonly filter?: ConsumptionBudgetResourceGroupFilter;
    /**
    * notification block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#notification ConsumptionBudgetResourceGroup#notification}
    */
    readonly notification: ConsumptionBudgetResourceGroupNotification[] | cdktf.IResolvable;
    /**
    * time_period block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#time_period ConsumptionBudgetResourceGroup#time_period}
    */
    readonly timePeriod: ConsumptionBudgetResourceGroupTimePeriod;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#timeouts ConsumptionBudgetResourceGroup#timeouts}
    */
    readonly timeouts?: ConsumptionBudgetResourceGroupTimeouts;
}
export interface ConsumptionBudgetResourceGroupFilterDimension {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterDimensionToTerraform(struct?: ConsumptionBudgetResourceGroupFilterDimension | cdktf.IResolvable): any;
export declare function consumptionBudgetResourceGroupFilterDimensionToHclTerraform(struct?: ConsumptionBudgetResourceGroupFilterDimension | cdktf.IResolvable): any;
export declare class ConsumptionBudgetResourceGroupFilterDimensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConsumptionBudgetResourceGroupFilterDimension | cdktf.IResolvable | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupFilterDimension | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class ConsumptionBudgetResourceGroupFilterDimensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ConsumptionBudgetResourceGroupFilterDimension[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConsumptionBudgetResourceGroupFilterDimensionOutputReference;
}
export interface ConsumptionBudgetResourceGroupFilterTag {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#name ConsumptionBudgetResourceGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}
    */
    readonly operator?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#values ConsumptionBudgetResourceGroup#values}
    */
    readonly values: string[];
}
export declare function consumptionBudgetResourceGroupFilterTagToTerraform(struct?: ConsumptionBudgetResourceGroupFilterTag | cdktf.IResolvable): any;
export declare function consumptionBudgetResourceGroupFilterTagToHclTerraform(struct?: ConsumptionBudgetResourceGroupFilterTag | cdktf.IResolvable): any;
export declare class ConsumptionBudgetResourceGroupFilterTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConsumptionBudgetResourceGroupFilterTag | cdktf.IResolvable | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupFilterTag | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class ConsumptionBudgetResourceGroupFilterTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ConsumptionBudgetResourceGroupFilterTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConsumptionBudgetResourceGroupFilterTagOutputReference;
}
export interface ConsumptionBudgetResourceGroupFilter {
    /**
    * dimension block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#dimension ConsumptionBudgetResourceGroup#dimension}
    */
    readonly dimension?: ConsumptionBudgetResourceGroupFilterDimension[] | cdktf.IResolvable;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#tag ConsumptionBudgetResourceGroup#tag}
    */
    readonly tag?: ConsumptionBudgetResourceGroupFilterTag[] | cdktf.IResolvable;
}
export declare function consumptionBudgetResourceGroupFilterToTerraform(struct?: ConsumptionBudgetResourceGroupFilterOutputReference | ConsumptionBudgetResourceGroupFilter): any;
export declare function consumptionBudgetResourceGroupFilterToHclTerraform(struct?: ConsumptionBudgetResourceGroupFilterOutputReference | ConsumptionBudgetResourceGroupFilter): any;
export declare class ConsumptionBudgetResourceGroupFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetResourceGroupFilter | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupFilter | undefined);
    private _dimension;
    get dimension(): ConsumptionBudgetResourceGroupFilterDimensionList;
    putDimension(value: ConsumptionBudgetResourceGroupFilterDimension[] | cdktf.IResolvable): void;
    resetDimension(): void;
    get dimensionInput(): cdktf.IResolvable | ConsumptionBudgetResourceGroupFilterDimension[] | undefined;
    private _tag;
    get tag(): ConsumptionBudgetResourceGroupFilterTagList;
    putTag(value: ConsumptionBudgetResourceGroupFilterTag[] | cdktf.IResolvable): void;
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | ConsumptionBudgetResourceGroupFilterTag[] | undefined;
}
export interface ConsumptionBudgetResourceGroupNotification {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#contact_emails ConsumptionBudgetResourceGroup#contact_emails}
    */
    readonly contactEmails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#contact_groups ConsumptionBudgetResourceGroup#contact_groups}
    */
    readonly contactGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#contact_roles ConsumptionBudgetResourceGroup#contact_roles}
    */
    readonly contactRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#enabled ConsumptionBudgetResourceGroup#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#operator ConsumptionBudgetResourceGroup#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#threshold ConsumptionBudgetResourceGroup#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#threshold_type ConsumptionBudgetResourceGroup#threshold_type}
    */
    readonly thresholdType?: string;
}
export declare function consumptionBudgetResourceGroupNotificationToTerraform(struct?: ConsumptionBudgetResourceGroupNotification | cdktf.IResolvable): any;
export declare function consumptionBudgetResourceGroupNotificationToHclTerraform(struct?: ConsumptionBudgetResourceGroupNotification | cdktf.IResolvable): any;
export declare class ConsumptionBudgetResourceGroupNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ConsumptionBudgetResourceGroupNotification | cdktf.IResolvable | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupNotification | cdktf.IResolvable | undefined);
    private _contactEmails?;
    get contactEmails(): string[];
    set contactEmails(value: string[]);
    resetContactEmails(): void;
    get contactEmailsInput(): string[] | undefined;
    private _contactGroups?;
    get contactGroups(): string[];
    set contactGroups(value: string[]);
    resetContactGroups(): void;
    get contactGroupsInput(): string[] | undefined;
    private _contactRoles?;
    get contactRoles(): string[];
    set contactRoles(value: string[]);
    resetContactRoles(): void;
    get contactRolesInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _thresholdType?;
    get thresholdType(): string;
    set thresholdType(value: string);
    resetThresholdType(): void;
    get thresholdTypeInput(): string | undefined;
}
export declare class ConsumptionBudgetResourceGroupNotificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ConsumptionBudgetResourceGroupNotification[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ConsumptionBudgetResourceGroupNotificationOutputReference;
}
export interface ConsumptionBudgetResourceGroupTimePeriod {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#end_date ConsumptionBudgetResourceGroup#end_date}
    */
    readonly endDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#start_date ConsumptionBudgetResourceGroup#start_date}
    */
    readonly startDate: string;
}
export declare function consumptionBudgetResourceGroupTimePeriodToTerraform(struct?: ConsumptionBudgetResourceGroupTimePeriodOutputReference | ConsumptionBudgetResourceGroupTimePeriod): any;
export declare function consumptionBudgetResourceGroupTimePeriodToHclTerraform(struct?: ConsumptionBudgetResourceGroupTimePeriodOutputReference | ConsumptionBudgetResourceGroupTimePeriod): any;
export declare class ConsumptionBudgetResourceGroupTimePeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetResourceGroupTimePeriod | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupTimePeriod | undefined);
    private _endDate?;
    get endDate(): string;
    set endDate(value: string);
    resetEndDate(): void;
    get endDateInput(): string | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    get startDateInput(): string | undefined;
}
export interface ConsumptionBudgetResourceGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#create ConsumptionBudgetResourceGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#delete ConsumptionBudgetResourceGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#read ConsumptionBudgetResourceGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#update ConsumptionBudgetResourceGroup#update}
    */
    readonly update?: string;
}
export declare function consumptionBudgetResourceGroupTimeoutsToTerraform(struct?: ConsumptionBudgetResourceGroupTimeouts | cdktf.IResolvable): any;
export declare function consumptionBudgetResourceGroupTimeoutsToHclTerraform(struct?: ConsumptionBudgetResourceGroupTimeouts | cdktf.IResolvable): any;
export declare class ConsumptionBudgetResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ConsumptionBudgetResourceGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ConsumptionBudgetResourceGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group azurerm_consumption_budget_resource_group}
*/
export declare class ConsumptionBudgetResourceGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_consumption_budget_resource_group";
    /**
    * Generates CDKTF code for importing a ConsumptionBudgetResourceGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ConsumptionBudgetResourceGroup to import
    * @param importFromId The id of the existing ConsumptionBudgetResourceGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ConsumptionBudgetResourceGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/consumption_budget_resource_group azurerm_consumption_budget_resource_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConsumptionBudgetResourceGroupConfig
    */
    constructor(scope: Construct, id: string, config: ConsumptionBudgetResourceGroupConfig);
    private _amount?;
    get amount(): number;
    set amount(value: number);
    get amountInput(): number | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _timeGrain?;
    get timeGrain(): string;
    set timeGrain(value: string);
    resetTimeGrain(): void;
    get timeGrainInput(): string | undefined;
    private _filter;
    get filter(): ConsumptionBudgetResourceGroupFilterOutputReference;
    putFilter(value: ConsumptionBudgetResourceGroupFilter): void;
    resetFilter(): void;
    get filterInput(): ConsumptionBudgetResourceGroupFilter | undefined;
    private _notification;
    get notification(): ConsumptionBudgetResourceGroupNotificationList;
    putNotification(value: ConsumptionBudgetResourceGroupNotification[] | cdktf.IResolvable): void;
    get notificationInput(): cdktf.IResolvable | ConsumptionBudgetResourceGroupNotification[] | undefined;
    private _timePeriod;
    get timePeriod(): ConsumptionBudgetResourceGroupTimePeriodOutputReference;
    putTimePeriod(value: ConsumptionBudgetResourceGroupTimePeriod): void;
    get timePeriodInput(): ConsumptionBudgetResourceGroupTimePeriod | undefined;
    private _timeouts;
    get timeouts(): ConsumptionBudgetResourceGroupTimeoutsOutputReference;
    putTimeouts(value: ConsumptionBudgetResourceGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ConsumptionBudgetResourceGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
