/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerConnectedRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#audit_log_enabled ContainerConnectedRegistry#audit_log_enabled}
    */
    readonly auditLogEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#client_token_ids ContainerConnectedRegistry#client_token_ids}
    */
    readonly clientTokenIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#container_registry_id ContainerConnectedRegistry#container_registry_id}
    */
    readonly containerRegistryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#id ContainerConnectedRegistry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#log_level ContainerConnectedRegistry#log_level}
    */
    readonly logLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#mode ContainerConnectedRegistry#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#name ContainerConnectedRegistry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#parent_registry_id ContainerConnectedRegistry#parent_registry_id}
    */
    readonly parentRegistryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#sync_message_ttl ContainerConnectedRegistry#sync_message_ttl}
    */
    readonly syncMessageTtl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#sync_schedule ContainerConnectedRegistry#sync_schedule}
    */
    readonly syncSchedule?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#sync_token_id ContainerConnectedRegistry#sync_token_id}
    */
    readonly syncTokenId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#sync_window ContainerConnectedRegistry#sync_window}
    */
    readonly syncWindow?: string;
    /**
    * notification block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#notification ContainerConnectedRegistry#notification}
    */
    readonly notification?: ContainerConnectedRegistryNotification[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#timeouts ContainerConnectedRegistry#timeouts}
    */
    readonly timeouts?: ContainerConnectedRegistryTimeouts;
}
export interface ContainerConnectedRegistryNotification {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#action ContainerConnectedRegistry#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#digest ContainerConnectedRegistry#digest}
    */
    readonly digest?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#name ContainerConnectedRegistry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#tag ContainerConnectedRegistry#tag}
    */
    readonly tag?: string;
}
export declare function containerConnectedRegistryNotificationToTerraform(struct?: ContainerConnectedRegistryNotification | cdktf.IResolvable): any;
export declare function containerConnectedRegistryNotificationToHclTerraform(struct?: ContainerConnectedRegistryNotification | cdktf.IResolvable): any;
export declare class ContainerConnectedRegistryNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ContainerConnectedRegistryNotification | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerConnectedRegistryNotification | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _digest?;
    get digest(): string;
    set digest(value: string);
    resetDigest(): void;
    get digestInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export declare class ContainerConnectedRegistryNotificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ContainerConnectedRegistryNotification[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ContainerConnectedRegistryNotificationOutputReference;
}
export interface ContainerConnectedRegistryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#create ContainerConnectedRegistry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#delete ContainerConnectedRegistry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#read ContainerConnectedRegistry#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#update ContainerConnectedRegistry#update}
    */
    readonly update?: string;
}
export declare function containerConnectedRegistryTimeoutsToTerraform(struct?: ContainerConnectedRegistryTimeouts | cdktf.IResolvable): any;
export declare function containerConnectedRegistryTimeoutsToHclTerraform(struct?: ContainerConnectedRegistryTimeouts | cdktf.IResolvable): any;
export declare class ContainerConnectedRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerConnectedRegistryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerConnectedRegistryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry azurerm_container_connected_registry}
*/
export declare class ContainerConnectedRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_connected_registry";
    /**
    * Generates CDKTF code for importing a ContainerConnectedRegistry resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerConnectedRegistry to import
    * @param importFromId The id of the existing ContainerConnectedRegistry that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerConnectedRegistry to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/container_connected_registry azurerm_container_connected_registry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerConnectedRegistryConfig
    */
    constructor(scope: Construct, id: string, config: ContainerConnectedRegistryConfig);
    private _auditLogEnabled?;
    get auditLogEnabled(): boolean | cdktf.IResolvable;
    set auditLogEnabled(value: boolean | cdktf.IResolvable);
    resetAuditLogEnabled(): void;
    get auditLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientTokenIds?;
    get clientTokenIds(): string[];
    set clientTokenIds(value: string[]);
    resetClientTokenIds(): void;
    get clientTokenIdsInput(): string[] | undefined;
    private _containerRegistryId?;
    get containerRegistryId(): string;
    set containerRegistryId(value: string);
    get containerRegistryIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentRegistryId?;
    get parentRegistryId(): string;
    set parentRegistryId(value: string);
    resetParentRegistryId(): void;
    get parentRegistryIdInput(): string | undefined;
    private _syncMessageTtl?;
    get syncMessageTtl(): string;
    set syncMessageTtl(value: string);
    resetSyncMessageTtl(): void;
    get syncMessageTtlInput(): string | undefined;
    private _syncSchedule?;
    get syncSchedule(): string;
    set syncSchedule(value: string);
    resetSyncSchedule(): void;
    get syncScheduleInput(): string | undefined;
    private _syncTokenId?;
    get syncTokenId(): string;
    set syncTokenId(value: string);
    get syncTokenIdInput(): string | undefined;
    private _syncWindow?;
    get syncWindow(): string;
    set syncWindow(value: string);
    resetSyncWindow(): void;
    get syncWindowInput(): string | undefined;
    private _notification;
    get notification(): ContainerConnectedRegistryNotificationList;
    putNotification(value: ContainerConnectedRegistryNotification[] | cdktf.IResolvable): void;
    resetNotification(): void;
    get notificationInput(): cdktf.IResolvable | ContainerConnectedRegistryNotification[] | undefined;
    private _timeouts;
    get timeouts(): ContainerConnectedRegistryTimeoutsOutputReference;
    putTimeouts(value: ContainerConnectedRegistryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerConnectedRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
