/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbCassandraTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#analytical_storage_ttl CosmosdbCassandraTable#analytical_storage_ttl}
    */
    readonly analyticalStorageTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#cassandra_keyspace_id CosmosdbCassandraTable#cassandra_keyspace_id}
    */
    readonly cassandraKeyspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#default_ttl CosmosdbCassandraTable#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#id CosmosdbCassandraTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#throughput CosmosdbCassandraTable#throughput}
    */
    readonly throughput?: number;
    /**
    * autoscale_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#autoscale_settings CosmosdbCassandraTable#autoscale_settings}
    */
    readonly autoscaleSettings?: CosmosdbCassandraTableAutoscaleSettings;
    /**
    * schema block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#schema CosmosdbCassandraTable#schema}
    */
    readonly schema: CosmosdbCassandraTableSchema;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#timeouts CosmosdbCassandraTable#timeouts}
    */
    readonly timeouts?: CosmosdbCassandraTableTimeouts;
}
export interface CosmosdbCassandraTableAutoscaleSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#max_throughput CosmosdbCassandraTable#max_throughput}
    */
    readonly maxThroughput?: number;
}
export declare function cosmosdbCassandraTableAutoscaleSettingsToTerraform(struct?: CosmosdbCassandraTableAutoscaleSettingsOutputReference | CosmosdbCassandraTableAutoscaleSettings): any;
export declare function cosmosdbCassandraTableAutoscaleSettingsToHclTerraform(struct?: CosmosdbCassandraTableAutoscaleSettingsOutputReference | CosmosdbCassandraTableAutoscaleSettings): any;
export declare class CosmosdbCassandraTableAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbCassandraTableAutoscaleSettings | undefined;
    set internalValue(value: CosmosdbCassandraTableAutoscaleSettings | undefined);
    private _maxThroughput?;
    get maxThroughput(): number;
    set maxThroughput(value: number);
    resetMaxThroughput(): void;
    get maxThroughputInput(): number | undefined;
}
export interface CosmosdbCassandraTableSchemaClusterKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#order_by CosmosdbCassandraTable#order_by}
    */
    readonly orderBy: string;
}
export declare function cosmosdbCassandraTableSchemaClusterKeyToTerraform(struct?: CosmosdbCassandraTableSchemaClusterKey | cdktf.IResolvable): any;
export declare function cosmosdbCassandraTableSchemaClusterKeyToHclTerraform(struct?: CosmosdbCassandraTableSchemaClusterKey | cdktf.IResolvable): any;
export declare class CosmosdbCassandraTableSchemaClusterKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbCassandraTableSchemaClusterKey | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbCassandraTableSchemaClusterKey | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orderBy?;
    get orderBy(): string;
    set orderBy(value: string);
    get orderByInput(): string | undefined;
}
export declare class CosmosdbCassandraTableSchemaClusterKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbCassandraTableSchemaClusterKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbCassandraTableSchemaClusterKeyOutputReference;
}
export interface CosmosdbCassandraTableSchemaColumn {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#type CosmosdbCassandraTable#type}
    */
    readonly type: string;
}
export declare function cosmosdbCassandraTableSchemaColumnToTerraform(struct?: CosmosdbCassandraTableSchemaColumn | cdktf.IResolvable): any;
export declare function cosmosdbCassandraTableSchemaColumnToHclTerraform(struct?: CosmosdbCassandraTableSchemaColumn | cdktf.IResolvable): any;
export declare class CosmosdbCassandraTableSchemaColumnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbCassandraTableSchemaColumn | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbCassandraTableSchemaColumn | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class CosmosdbCassandraTableSchemaColumnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbCassandraTableSchemaColumn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbCassandraTableSchemaColumnOutputReference;
}
export interface CosmosdbCassandraTableSchemaPartitionKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#name CosmosdbCassandraTable#name}
    */
    readonly name: string;
}
export declare function cosmosdbCassandraTableSchemaPartitionKeyToTerraform(struct?: CosmosdbCassandraTableSchemaPartitionKey | cdktf.IResolvable): any;
export declare function cosmosdbCassandraTableSchemaPartitionKeyToHclTerraform(struct?: CosmosdbCassandraTableSchemaPartitionKey | cdktf.IResolvable): any;
export declare class CosmosdbCassandraTableSchemaPartitionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbCassandraTableSchemaPartitionKey | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbCassandraTableSchemaPartitionKey | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class CosmosdbCassandraTableSchemaPartitionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbCassandraTableSchemaPartitionKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbCassandraTableSchemaPartitionKeyOutputReference;
}
export interface CosmosdbCassandraTableSchema {
    /**
    * cluster_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#cluster_key CosmosdbCassandraTable#cluster_key}
    */
    readonly clusterKey?: CosmosdbCassandraTableSchemaClusterKey[] | cdktf.IResolvable;
    /**
    * column block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#column CosmosdbCassandraTable#column}
    */
    readonly column: CosmosdbCassandraTableSchemaColumn[] | cdktf.IResolvable;
    /**
    * partition_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#partition_key CosmosdbCassandraTable#partition_key}
    */
    readonly partitionKey: CosmosdbCassandraTableSchemaPartitionKey[] | cdktf.IResolvable;
}
export declare function cosmosdbCassandraTableSchemaToTerraform(struct?: CosmosdbCassandraTableSchemaOutputReference | CosmosdbCassandraTableSchema): any;
export declare function cosmosdbCassandraTableSchemaToHclTerraform(struct?: CosmosdbCassandraTableSchemaOutputReference | CosmosdbCassandraTableSchema): any;
export declare class CosmosdbCassandraTableSchemaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbCassandraTableSchema | undefined;
    set internalValue(value: CosmosdbCassandraTableSchema | undefined);
    private _clusterKey;
    get clusterKey(): CosmosdbCassandraTableSchemaClusterKeyList;
    putClusterKey(value: CosmosdbCassandraTableSchemaClusterKey[] | cdktf.IResolvable): void;
    resetClusterKey(): void;
    get clusterKeyInput(): cdktf.IResolvable | CosmosdbCassandraTableSchemaClusterKey[] | undefined;
    private _column;
    get column(): CosmosdbCassandraTableSchemaColumnList;
    putColumn(value: CosmosdbCassandraTableSchemaColumn[] | cdktf.IResolvable): void;
    get columnInput(): cdktf.IResolvable | CosmosdbCassandraTableSchemaColumn[] | undefined;
    private _partitionKey;
    get partitionKey(): CosmosdbCassandraTableSchemaPartitionKeyList;
    putPartitionKey(value: CosmosdbCassandraTableSchemaPartitionKey[] | cdktf.IResolvable): void;
    get partitionKeyInput(): cdktf.IResolvable | CosmosdbCassandraTableSchemaPartitionKey[] | undefined;
}
export interface CosmosdbCassandraTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#create CosmosdbCassandraTable#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#delete CosmosdbCassandraTable#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#read CosmosdbCassandraTable#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#update CosmosdbCassandraTable#update}
    */
    readonly update?: string;
}
export declare function cosmosdbCassandraTableTimeoutsToTerraform(struct?: CosmosdbCassandraTableTimeouts | cdktf.IResolvable): any;
export declare function cosmosdbCassandraTableTimeoutsToHclTerraform(struct?: CosmosdbCassandraTableTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbCassandraTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbCassandraTableTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbCassandraTableTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table azurerm_cosmosdb_cassandra_table}
*/
export declare class CosmosdbCassandraTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cosmosdb_cassandra_table";
    /**
    * Generates CDKTF code for importing a CosmosdbCassandraTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CosmosdbCassandraTable to import
    * @param importFromId The id of the existing CosmosdbCassandraTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CosmosdbCassandraTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/cosmosdb_cassandra_table azurerm_cosmosdb_cassandra_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbCassandraTableConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbCassandraTableConfig);
    private _analyticalStorageTtl?;
    get analyticalStorageTtl(): number;
    set analyticalStorageTtl(value: number);
    resetAnalyticalStorageTtl(): void;
    get analyticalStorageTtlInput(): number | undefined;
    private _cassandraKeyspaceId?;
    get cassandraKeyspaceId(): string;
    set cassandraKeyspaceId(value: string);
    get cassandraKeyspaceIdInput(): string | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    get autoscaleSettings(): CosmosdbCassandraTableAutoscaleSettingsOutputReference;
    putAutoscaleSettings(value: CosmosdbCassandraTableAutoscaleSettings): void;
    resetAutoscaleSettings(): void;
    get autoscaleSettingsInput(): CosmosdbCassandraTableAutoscaleSettings | undefined;
    private _schema;
    get schema(): CosmosdbCassandraTableSchemaOutputReference;
    putSchema(value: CosmosdbCassandraTableSchema): void;
    get schemaInput(): CosmosdbCassandraTableSchema | undefined;
    private _timeouts;
    get timeouts(): CosmosdbCassandraTableTimeoutsOutputReference;
    putTimeouts(value: CosmosdbCassandraTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CosmosdbCassandraTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
