/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_subscription#api_management_id DataAzurermApiManagementSubscription#api_management_id}
    */
    readonly apiManagementId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_subscription#id DataAzurermApiManagementSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_subscription#subscription_id DataAzurermApiManagementSubscription#subscription_id}
    */
    readonly subscriptionId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_subscription#timeouts DataAzurermApiManagementSubscription#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementSubscriptionTimeouts;
}
export interface DataAzurermApiManagementSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_subscription#read DataAzurermApiManagementSubscription#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementSubscriptionTimeoutsToTerraform(struct?: DataAzurermApiManagementSubscriptionTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermApiManagementSubscriptionTimeoutsToHclTerraform(struct?: DataAzurermApiManagementSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApiManagementSubscriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermApiManagementSubscriptionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_subscription azurerm_api_management_subscription}
*/
export declare class DataAzurermApiManagementSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_api_management_subscription";
    /**
    * Generates CDKTF code for importing a DataAzurermApiManagementSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermApiManagementSubscription to import
    * @param importFromId The id of the existing DataAzurermApiManagementSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermApiManagementSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_subscription azurerm_api_management_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementSubscriptionConfig);
    get allowTracing(): cdktf.IResolvable;
    get apiId(): string;
    private _apiManagementId?;
    get apiManagementId(): string;
    set apiManagementId(value: string);
    get apiManagementIdInput(): string | undefined;
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get primaryKey(): string;
    get productId(): string;
    get secondaryKey(): string;
    get state(): string;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    get subscriptionIdInput(): string | undefined;
    get userId(): string;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementSubscriptionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermApiManagementSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
