/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_user#api_management_name DataAzurermApiManagementUser#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_user#id DataAzurermApiManagementUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_user#resource_group_name DataAzurermApiManagementUser#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_user#user_id DataAzurermApiManagementUser#user_id}
    */
    readonly userId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_user#timeouts DataAzurermApiManagementUser#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementUserTimeouts;
}
export interface DataAzurermApiManagementUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_user#read DataAzurermApiManagementUser#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementUserTimeoutsToTerraform(struct?: DataAzurermApiManagementUserTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermApiManagementUserTimeoutsToHclTerraform(struct?: DataAzurermApiManagementUserTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApiManagementUserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermApiManagementUserTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_user azurerm_api_management_user}
*/
export declare class DataAzurermApiManagementUser extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_api_management_user";
    /**
    * Generates CDKTF code for importing a DataAzurermApiManagementUser resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermApiManagementUser to import
    * @param importFromId The id of the existing DataAzurermApiManagementUser that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_user#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermApiManagementUser to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/api_management_user azurerm_api_management_user} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementUserConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementUserConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    get email(): string;
    get firstName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastName(): string;
    get note(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get state(): string;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementUserTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermApiManagementUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
