/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataShareDatasetBlobStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/data_share_dataset_blob_storage#data_share_id DataAzurermDataShareDatasetBlobStorage#data_share_id}
    */
    readonly dataShareId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/data_share_dataset_blob_storage#id DataAzurermDataShareDatasetBlobStorage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/data_share_dataset_blob_storage#name DataAzurermDataShareDatasetBlobStorage#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/data_share_dataset_blob_storage#timeouts DataAzurermDataShareDatasetBlobStorage#timeouts}
    */
    readonly timeouts?: DataAzurermDataShareDatasetBlobStorageTimeouts;
}
export interface DataAzurermDataShareDatasetBlobStorageStorageAccount {
}
export declare function dataAzurermDataShareDatasetBlobStorageStorageAccountToTerraform(struct?: DataAzurermDataShareDatasetBlobStorageStorageAccount): any;
export declare function dataAzurermDataShareDatasetBlobStorageStorageAccountToHclTerraform(struct?: DataAzurermDataShareDatasetBlobStorageStorageAccount): any;
export declare class DataAzurermDataShareDatasetBlobStorageStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataShareDatasetBlobStorageStorageAccount | undefined;
    set internalValue(value: DataAzurermDataShareDatasetBlobStorageStorageAccount | undefined);
    get name(): string;
    get resourceGroupName(): string;
    get subscriptionId(): string;
}
export declare class DataAzurermDataShareDatasetBlobStorageStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataShareDatasetBlobStorageStorageAccountOutputReference;
}
export interface DataAzurermDataShareDatasetBlobStorageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/data_share_dataset_blob_storage#read DataAzurermDataShareDatasetBlobStorage#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetBlobStorageTimeoutsToTerraform(struct?: DataAzurermDataShareDatasetBlobStorageTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDataShareDatasetBlobStorageTimeoutsToHclTerraform(struct?: DataAzurermDataShareDatasetBlobStorageTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataShareDatasetBlobStorageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDataShareDatasetBlobStorageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDataShareDatasetBlobStorageTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/data_share_dataset_blob_storage azurerm_data_share_dataset_blob_storage}
*/
export declare class DataAzurermDataShareDatasetBlobStorage extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_data_share_dataset_blob_storage";
    /**
    * Generates CDKTF code for importing a DataAzurermDataShareDatasetBlobStorage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDataShareDatasetBlobStorage to import
    * @param importFromId The id of the existing DataAzurermDataShareDatasetBlobStorage that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/data_share_dataset_blob_storage#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDataShareDatasetBlobStorage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/data_share_dataset_blob_storage azurerm_data_share_dataset_blob_storage} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataShareDatasetBlobStorageConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetBlobStorageConfig);
    get containerName(): string;
    private _dataShareId?;
    get dataShareId(): string;
    set dataShareId(value: string);
    get dataShareIdInput(): string | undefined;
    get displayName(): string;
    get filePath(): string;
    get folderPath(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccount;
    get storageAccount(): DataAzurermDataShareDatasetBlobStorageStorageAccountList;
    private _timeouts;
    get timeouts(): DataAzurermDataShareDatasetBlobStorageTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataShareDatasetBlobStorageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDataShareDatasetBlobStorageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
