/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDevCenterProjectPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/dev_center_project_pool#dev_center_project_id DataAzurermDevCenterProjectPool#dev_center_project_id}
    */
    readonly devCenterProjectId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/dev_center_project_pool#id DataAzurermDevCenterProjectPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/dev_center_project_pool#name DataAzurermDevCenterProjectPool#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/dev_center_project_pool#timeouts DataAzurermDevCenterProjectPool#timeouts}
    */
    readonly timeouts?: DataAzurermDevCenterProjectPoolTimeouts;
}
export interface DataAzurermDevCenterProjectPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/dev_center_project_pool#read DataAzurermDevCenterProjectPool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDevCenterProjectPoolTimeoutsToTerraform(struct?: DataAzurermDevCenterProjectPoolTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDevCenterProjectPoolTimeoutsToHclTerraform(struct?: DataAzurermDevCenterProjectPoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDevCenterProjectPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDevCenterProjectPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDevCenterProjectPoolTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/dev_center_project_pool azurerm_dev_center_project_pool}
*/
export declare class DataAzurermDevCenterProjectPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dev_center_project_pool";
    /**
    * Generates CDKTF code for importing a DataAzurermDevCenterProjectPool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDevCenterProjectPool to import
    * @param importFromId The id of the existing DataAzurermDevCenterProjectPool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/dev_center_project_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDevCenterProjectPool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/dev_center_project_pool azurerm_dev_center_project_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDevCenterProjectPoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDevCenterProjectPoolConfig);
    get devBoxDefinitionName(): string;
    get devCenterAttachedNetworkName(): string;
    private _devCenterProjectId?;
    get devCenterProjectId(): string;
    set devCenterProjectId(value: string);
    get devCenterProjectIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get localAdministratorEnabled(): cdktf.IResolvable;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get singleSignOnEnabled(): cdktf.IResolvable;
    get stopOnDisconnectGracePeriodMinutes(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermDevCenterProjectPoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDevCenterProjectPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDevCenterProjectPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
