/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermElasticSanVolumeSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/elastic_san_volume_snapshot#id DataAzurermElasticSanVolumeSnapshot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/elastic_san_volume_snapshot#name DataAzurermElasticSanVolumeSnapshot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/elastic_san_volume_snapshot#volume_group_id DataAzurermElasticSanVolumeSnapshot#volume_group_id}
    */
    readonly volumeGroupId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/elastic_san_volume_snapshot#timeouts DataAzurermElasticSanVolumeSnapshot#timeouts}
    */
    readonly timeouts?: DataAzurermElasticSanVolumeSnapshotTimeouts;
}
export interface DataAzurermElasticSanVolumeSnapshotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/elastic_san_volume_snapshot#read DataAzurermElasticSanVolumeSnapshot#read}
    */
    readonly read?: string;
}
export declare function dataAzurermElasticSanVolumeSnapshotTimeoutsToTerraform(struct?: DataAzurermElasticSanVolumeSnapshotTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermElasticSanVolumeSnapshotTimeoutsToHclTerraform(struct?: DataAzurermElasticSanVolumeSnapshotTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermElasticSanVolumeSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermElasticSanVolumeSnapshotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermElasticSanVolumeSnapshotTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/elastic_san_volume_snapshot azurerm_elastic_san_volume_snapshot}
*/
export declare class DataAzurermElasticSanVolumeSnapshot extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_elastic_san_volume_snapshot";
    /**
    * Generates CDKTF code for importing a DataAzurermElasticSanVolumeSnapshot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermElasticSanVolumeSnapshot to import
    * @param importFromId The id of the existing DataAzurermElasticSanVolumeSnapshot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/elastic_san_volume_snapshot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermElasticSanVolumeSnapshot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/elastic_san_volume_snapshot azurerm_elastic_san_volume_snapshot} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermElasticSanVolumeSnapshotConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermElasticSanVolumeSnapshotConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get sourceId(): string;
    get sourceVolumeSizeInGib(): number;
    private _volumeGroupId?;
    get volumeGroupId(): string;
    set volumeGroupId(value: string);
    get volumeGroupIdInput(): string | undefined;
    get volumeName(): string;
    private _timeouts;
    get timeouts(): DataAzurermElasticSanVolumeSnapshotTimeoutsOutputReference;
    putTimeouts(value: DataAzurermElasticSanVolumeSnapshotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermElasticSanVolumeSnapshotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
