/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermManagedDisksConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/managed_disks#id DataAzurermManagedDisks#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/managed_disks#resource_group_name DataAzurermManagedDisks#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/managed_disks#timeouts DataAzurermManagedDisks#timeouts}
    */
    readonly timeouts?: DataAzurermManagedDisksTimeouts;
}
export interface DataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKey {
}
export declare function dataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKeyToTerraform(struct?: DataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKey): any;
export declare function dataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKeyToHclTerraform(struct?: DataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKey): any;
export declare class DataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKey | undefined;
    set internalValue(value: DataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKey | undefined);
    get secretUrl(): string;
    get sourceVaultId(): string;
}
export declare class DataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKeyOutputReference;
}
export interface DataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKey {
}
export declare function dataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKeyToTerraform(struct?: DataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKey): any;
export declare function dataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKeyToHclTerraform(struct?: DataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKey): any;
export declare class DataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKey | undefined;
    set internalValue(value: DataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKey | undefined);
    get keyUrl(): string;
    get sourceVaultId(): string;
}
export declare class DataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKeyOutputReference;
}
export interface DataAzurermManagedDisksDiskEncryptionSettings {
}
export declare function dataAzurermManagedDisksDiskEncryptionSettingsToTerraform(struct?: DataAzurermManagedDisksDiskEncryptionSettings): any;
export declare function dataAzurermManagedDisksDiskEncryptionSettingsToHclTerraform(struct?: DataAzurermManagedDisksDiskEncryptionSettings): any;
export declare class DataAzurermManagedDisksDiskEncryptionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermManagedDisksDiskEncryptionSettings | undefined;
    set internalValue(value: DataAzurermManagedDisksDiskEncryptionSettings | undefined);
    private _diskEncryptionKey;
    get diskEncryptionKey(): DataAzurermManagedDisksDiskEncryptionSettingsDiskEncryptionKeyList;
    get enabled(): cdktf.IResolvable;
    private _keyEncryptionKey;
    get keyEncryptionKey(): DataAzurermManagedDisksDiskEncryptionSettingsKeyEncryptionKeyList;
}
export declare class DataAzurermManagedDisksDiskEncryptionSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermManagedDisksDiskEncryptionSettingsOutputReference;
}
export interface DataAzurermManagedDisksDisk {
}
export declare function dataAzurermManagedDisksDiskToTerraform(struct?: DataAzurermManagedDisksDisk): any;
export declare function dataAzurermManagedDisksDiskToHclTerraform(struct?: DataAzurermManagedDisksDisk): any;
export declare class DataAzurermManagedDisksDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermManagedDisksDisk | undefined;
    set internalValue(value: DataAzurermManagedDisksDisk | undefined);
    get createOption(): string;
    get diskAccessId(): string;
    get diskEncryptionSetId(): string;
    get diskIopsReadWrite(): number;
    get diskMbpsReadWrite(): number;
    get diskSizeInGb(): number;
    private _encryptionSettings;
    get encryptionSettings(): DataAzurermManagedDisksDiskEncryptionSettingsList;
    get id(): string;
    get imageReferenceId(): string;
    get location(): string;
    get name(): string;
    get networkAccessPolicy(): string;
    get osType(): string;
    get sourceResourceId(): string;
    get sourceUri(): string;
    get storageAccountId(): string;
    get storageAccountType(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get zones(): string[];
}
export declare class DataAzurermManagedDisksDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermManagedDisksDiskOutputReference;
}
export interface DataAzurermManagedDisksTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/managed_disks#read DataAzurermManagedDisks#read}
    */
    readonly read?: string;
}
export declare function dataAzurermManagedDisksTimeoutsToTerraform(struct?: DataAzurermManagedDisksTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermManagedDisksTimeoutsToHclTerraform(struct?: DataAzurermManagedDisksTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermManagedDisksTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermManagedDisksTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermManagedDisksTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/managed_disks azurerm_managed_disks}
*/
export declare class DataAzurermManagedDisks extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_managed_disks";
    /**
    * Generates CDKTF code for importing a DataAzurermManagedDisks resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermManagedDisks to import
    * @param importFromId The id of the existing DataAzurermManagedDisks that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/managed_disks#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermManagedDisks to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/managed_disks azurerm_managed_disks} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermManagedDisksConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermManagedDisksConfig);
    private _disk;
    get disk(): DataAzurermManagedDisksDiskList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermManagedDisksTimeoutsOutputReference;
    putTimeouts(value: DataAzurermManagedDisksTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermManagedDisksTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
