/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMssqlFailoverGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/mssql_failover_group#id DataAzurermMssqlFailoverGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/mssql_failover_group#name DataAzurermMssqlFailoverGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/mssql_failover_group#server_id DataAzurermMssqlFailoverGroup#server_id}
    */
    readonly serverId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/mssql_failover_group#timeouts DataAzurermMssqlFailoverGroup#timeouts}
    */
    readonly timeouts?: DataAzurermMssqlFailoverGroupTimeouts;
}
export interface DataAzurermMssqlFailoverGroupPartnerServer {
}
export declare function dataAzurermMssqlFailoverGroupPartnerServerToTerraform(struct?: DataAzurermMssqlFailoverGroupPartnerServer): any;
export declare function dataAzurermMssqlFailoverGroupPartnerServerToHclTerraform(struct?: DataAzurermMssqlFailoverGroupPartnerServer): any;
export declare class DataAzurermMssqlFailoverGroupPartnerServerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMssqlFailoverGroupPartnerServer | undefined;
    set internalValue(value: DataAzurermMssqlFailoverGroupPartnerServer | undefined);
    get id(): string;
    get location(): string;
    get role(): string;
}
export declare class DataAzurermMssqlFailoverGroupPartnerServerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMssqlFailoverGroupPartnerServerOutputReference;
}
export interface DataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicy {
}
export declare function dataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicyToTerraform(struct?: DataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicy): any;
export declare function dataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicyToHclTerraform(struct?: DataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicy): any;
export declare class DataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    set internalValue(value: DataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicy | undefined);
    get graceMinutes(): number;
    get mode(): string;
}
export declare class DataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicyOutputReference;
}
export interface DataAzurermMssqlFailoverGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/mssql_failover_group#read DataAzurermMssqlFailoverGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMssqlFailoverGroupTimeoutsToTerraform(struct?: DataAzurermMssqlFailoverGroupTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMssqlFailoverGroupTimeoutsToHclTerraform(struct?: DataAzurermMssqlFailoverGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMssqlFailoverGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMssqlFailoverGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMssqlFailoverGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/mssql_failover_group azurerm_mssql_failover_group}
*/
export declare class DataAzurermMssqlFailoverGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mssql_failover_group";
    /**
    * Generates CDKTF code for importing a DataAzurermMssqlFailoverGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMssqlFailoverGroup to import
    * @param importFromId The id of the existing DataAzurermMssqlFailoverGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/mssql_failover_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMssqlFailoverGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/mssql_failover_group azurerm_mssql_failover_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMssqlFailoverGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlFailoverGroupConfig);
    get databases(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _partnerServer;
    get partnerServer(): DataAzurermMssqlFailoverGroupPartnerServerList;
    private _readWriteEndpointFailoverPolicy;
    get readWriteEndpointFailoverPolicy(): DataAzurermMssqlFailoverGroupReadWriteEndpointFailoverPolicyList;
    get readonlyEndpointFailoverPolicyEnabled(): cdktf.IResolvable;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMssqlFailoverGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMssqlFailoverGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMssqlFailoverGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
