/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleAutonomousDatabaseBackupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backup#autonomous_database_id DataAzurermOracleAutonomousDatabaseBackup#autonomous_database_id}
    */
    readonly autonomousDatabaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backup#name DataAzurermOracleAutonomousDatabaseBackup#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backup#timeouts DataAzurermOracleAutonomousDatabaseBackup#timeouts}
    */
    readonly timeouts?: DataAzurermOracleAutonomousDatabaseBackupTimeouts;
}
export interface DataAzurermOracleAutonomousDatabaseBackupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backup#read DataAzurermOracleAutonomousDatabaseBackup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleAutonomousDatabaseBackupTimeoutsToTerraform(struct?: DataAzurermOracleAutonomousDatabaseBackupTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleAutonomousDatabaseBackupTimeoutsToHclTerraform(struct?: DataAzurermOracleAutonomousDatabaseBackupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleAutonomousDatabaseBackupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleAutonomousDatabaseBackupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleAutonomousDatabaseBackupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backup azurerm_oracle_autonomous_database_backup}
*/
export declare class DataAzurermOracleAutonomousDatabaseBackup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_autonomous_database_backup";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleAutonomousDatabaseBackup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleAutonomousDatabaseBackup to import
    * @param importFromId The id of the existing DataAzurermOracleAutonomousDatabaseBackup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backup#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleAutonomousDatabaseBackup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backup azurerm_oracle_autonomous_database_backup} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleAutonomousDatabaseBackupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleAutonomousDatabaseBackupConfig);
    get automatic(): cdktf.IResolvable;
    get autonomousDatabaseBackupOcid(): string;
    private _autonomousDatabaseId?;
    get autonomousDatabaseId(): string;
    set autonomousDatabaseId(value: string);
    get autonomousDatabaseIdInput(): string | undefined;
    get autonomousDatabaseOcid(): string;
    get databaseBackupSizeInTbs(): number;
    get databaseVersion(): string;
    get displayName(): string;
    get id(): string;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get provisioningState(): string;
    get restorable(): cdktf.IResolvable;
    get retentionPeriodInDays(): number;
    get timeAvailableTil(): string;
    get timeEnded(): string;
    get timeStarted(): string;
    get type(): string;
    private _timeouts;
    get timeouts(): DataAzurermOracleAutonomousDatabaseBackupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleAutonomousDatabaseBackupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleAutonomousDatabaseBackupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
