/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleAutonomousDatabaseBackupsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backups#autonomous_database_id DataAzurermOracleAutonomousDatabaseBackups#autonomous_database_id}
    */
    readonly autonomousDatabaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backups#id DataAzurermOracleAutonomousDatabaseBackups#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backups#timeouts DataAzurermOracleAutonomousDatabaseBackups#timeouts}
    */
    readonly timeouts?: DataAzurermOracleAutonomousDatabaseBackupsTimeouts;
}
export interface DataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackups {
}
export declare function dataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackupsToTerraform(struct?: DataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackups): any;
export declare function dataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackupsToHclTerraform(struct?: DataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackups): any;
export declare class DataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackups | undefined;
    set internalValue(value: DataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackups | undefined);
    get automatic(): cdktf.IResolvable;
    get autonomousDatabaseBackupOcid(): string;
    get autonomousDatabaseOcid(): string;
    get databaseBackupSizeInTbs(): number;
    get databaseVersion(): string;
    get displayName(): string;
    get id(): string;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get location(): string;
    get provisioningState(): string;
    get restorable(): cdktf.IResolvable;
    get retentionPeriodInDays(): number;
    get timeAvailableTil(): string;
    get timeEnded(): string;
    get timeStarted(): string;
    get type(): string;
}
export declare class DataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackupsOutputReference;
}
export interface DataAzurermOracleAutonomousDatabaseBackupsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backups#read DataAzurermOracleAutonomousDatabaseBackups#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleAutonomousDatabaseBackupsTimeoutsToTerraform(struct?: DataAzurermOracleAutonomousDatabaseBackupsTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleAutonomousDatabaseBackupsTimeoutsToHclTerraform(struct?: DataAzurermOracleAutonomousDatabaseBackupsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleAutonomousDatabaseBackupsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleAutonomousDatabaseBackupsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleAutonomousDatabaseBackupsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backups azurerm_oracle_autonomous_database_backups}
*/
export declare class DataAzurermOracleAutonomousDatabaseBackups extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_autonomous_database_backups";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleAutonomousDatabaseBackups resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleAutonomousDatabaseBackups to import
    * @param importFromId The id of the existing DataAzurermOracleAutonomousDatabaseBackups that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backups#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleAutonomousDatabaseBackups to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_backups azurerm_oracle_autonomous_database_backups} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleAutonomousDatabaseBackupsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleAutonomousDatabaseBackupsConfig);
    private _autonomousDatabaseBackups;
    get autonomousDatabaseBackups(): DataAzurermOracleAutonomousDatabaseBackupsAutonomousDatabaseBackupsList;
    private _autonomousDatabaseId?;
    get autonomousDatabaseId(): string;
    set autonomousDatabaseId(value: string);
    get autonomousDatabaseIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermOracleAutonomousDatabaseBackupsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleAutonomousDatabaseBackupsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleAutonomousDatabaseBackupsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
