/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleAutonomousDatabaseCloneFromBackupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_backup#id DataAzurermOracleAutonomousDatabaseCloneFromBackup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_backup#name DataAzurermOracleAutonomousDatabaseCloneFromBackup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_backup#resource_group_name DataAzurermOracleAutonomousDatabaseCloneFromBackup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_backup#timeouts DataAzurermOracleAutonomousDatabaseCloneFromBackup#timeouts}
    */
    readonly timeouts?: DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeouts;
}
export interface DataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupSchedule {
}
export declare function dataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupScheduleToTerraform(struct?: DataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupSchedule): any;
export declare function dataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupScheduleToHclTerraform(struct?: DataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupSchedule): any;
export declare class DataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupSchedule | undefined;
    set internalValue(value: DataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupSchedule | undefined);
    get enabled(): cdktf.IResolvable;
    get repeatCadence(): string;
    get retentionPeriodInDays(): number;
    get timeOfBackupInUtc(): string;
}
export declare class DataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupScheduleOutputReference;
}
export interface DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_backup#read DataAzurermOracleAutonomousDatabaseCloneFromBackup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleAutonomousDatabaseCloneFromBackupTimeoutsToTerraform(struct?: DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleAutonomousDatabaseCloneFromBackupTimeoutsToHclTerraform(struct?: DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_backup azurerm_oracle_autonomous_database_clone_from_backup}
*/
export declare class DataAzurermOracleAutonomousDatabaseCloneFromBackup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_autonomous_database_clone_from_backup";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleAutonomousDatabaseCloneFromBackup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleAutonomousDatabaseCloneFromBackup to import
    * @param importFromId The id of the existing DataAzurermOracleAutonomousDatabaseCloneFromBackup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_backup#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleAutonomousDatabaseCloneFromBackup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_backup azurerm_oracle_autonomous_database_clone_from_backup} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleAutonomousDatabaseCloneFromBackupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleAutonomousDatabaseCloneFromBackupConfig);
    get actualUsedDataStorageSizeInTb(): number;
    get allocatedStorageSizeInTb(): number;
    get allowedIpAddresses(): string[];
    get autoScalingEnabled(): cdktf.IResolvable;
    get autoScalingForStorageEnabled(): cdktf.IResolvable;
    get availableUpgradeVersions(): string[];
    get backupRetentionPeriodInDays(): number;
    get characterSet(): string;
    get computeCount(): number;
    get computeModel(): string;
    get connectionStrings(): string[];
    get cpuCoreCount(): number;
    get customerContacts(): string[];
    get dataStorageSizeInGb(): number;
    get dataStorageSizeInTb(): number;
    get databaseVersion(): string;
    get databaseWorkload(): string;
    get displayName(): string;
    get failedDataRecoveryInSeconds(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get inMemoryAreaInGb(): number;
    get licenseModel(): string;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get localAdgAutoFailoverMaxDataLossLimitInSeconds(): number;
    get localDataGuardEnabled(): cdktf.IResolvable;
    get location(): string;
    private _longTermBackupSchedule;
    get longTermBackupSchedule(): DataAzurermOracleAutonomousDatabaseCloneFromBackupLongTermBackupScheduleList;
    get memoryPerOracleComputeUnitInGb(): number;
    get mtlsConnectionRequired(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nationalCharacterSet(): string;
    get nextLongTermBackupTimestamp(): string;
    get ociUrl(): string;
    get ocid(): string;
    get peerDatabaseIds(): string[];
    get preview(): cdktf.IResolvable;
    get previewVersionWithServiceTermsAccepted(): cdktf.IResolvable;
    get privateEndpointIp(): string;
    get privateEndpointLabel(): string;
    get privateEndpointUrl(): string;
    get provisionableCpus(): number[];
    get remoteDataGuardEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceConsoleUrl(): string;
    get sourceAutonomousDatabaseId(): string;
    get sqlWebDeveloperUrl(): string;
    get subnetId(): string;
    get supportedRegionsToCloneTo(): string[];
    private _tags;
    get tags(): cdktf.StringMap;
    get timeCreatedInUtc(): string;
    get timeDataGuardRoleChangedInUtc(): string;
    get timeDeletionOfFreeAutonomousDatabaseInUtc(): string;
    get timeLocalDataGuardEnabledInUtc(): string;
    get timeMaintenanceBeginInUtc(): string;
    get timeMaintenanceEndInUtc(): string;
    get timeOfLastFailoverInUtc(): string;
    get timeOfLastRefreshInUtc(): string;
    get timeOfLastRefreshPointInUtc(): string;
    get timeOfLastSwitchoverInUtc(): string;
    get timeReclamationOfFreeAutonomousDatabaseInUtc(): string;
    get usedDataStorageSizeInGb(): number;
    get usedDataStorageSizeInTb(): number;
    get virtualNetworkId(): string;
    private _timeouts;
    get timeouts(): DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleAutonomousDatabaseCloneFromBackupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
