/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleAutonomousDatabaseCloneFromDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_database#id DataAzurermOracleAutonomousDatabaseCloneFromDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_database#name DataAzurermOracleAutonomousDatabaseCloneFromDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_database#resource_group_name DataAzurermOracleAutonomousDatabaseCloneFromDatabase#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_database#timeouts DataAzurermOracleAutonomousDatabaseCloneFromDatabase#timeouts}
    */
    readonly timeouts?: DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeouts;
}
export interface DataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupSchedule {
}
export declare function dataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupScheduleToTerraform(struct?: DataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupSchedule): any;
export declare function dataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupScheduleToHclTerraform(struct?: DataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupSchedule): any;
export declare class DataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupSchedule | undefined;
    set internalValue(value: DataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupSchedule | undefined);
    get enabled(): cdktf.IResolvable;
    get repeatCadence(): string;
    get retentionPeriodInDays(): number;
    get timeOfBackupInUtc(): string;
}
export declare class DataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupScheduleOutputReference;
}
export interface DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_database#read DataAzurermOracleAutonomousDatabaseCloneFromDatabase#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeoutsToTerraform(struct?: DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeoutsToHclTerraform(struct?: DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_database azurerm_oracle_autonomous_database_clone_from_database}
*/
export declare class DataAzurermOracleAutonomousDatabaseCloneFromDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_autonomous_database_clone_from_database";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleAutonomousDatabaseCloneFromDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleAutonomousDatabaseCloneFromDatabase to import
    * @param importFromId The id of the existing DataAzurermOracleAutonomousDatabaseCloneFromDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleAutonomousDatabaseCloneFromDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_autonomous_database_clone_from_database azurerm_oracle_autonomous_database_clone_from_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleAutonomousDatabaseCloneFromDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleAutonomousDatabaseCloneFromDatabaseConfig);
    get actualUsedDataStorageSizeInTb(): number;
    get allocatedStorageSizeInTb(): number;
    get allowedIpAddresses(): string[];
    get autoScalingEnabled(): cdktf.IResolvable;
    get autoScalingForStorageEnabled(): cdktf.IResolvable;
    get availableUpgradeVersions(): string[];
    get backupRetentionPeriodInDays(): number;
    get characterSet(): string;
    get computeCount(): number;
    get computeModel(): string;
    get connectionStrings(): string[];
    get cpuCoreCount(): number;
    get customerContacts(): string[];
    get dataStorageSizeInGb(): number;
    get dataStorageSizeInTb(): number;
    get databaseVersion(): string;
    get databaseWorkload(): string;
    get displayName(): string;
    get failedDataRecoveryInSeconds(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get inMemoryAreaInGb(): number;
    get licenseModel(): string;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get localAdgAutoFailoverMaxDataLossLimitInSeconds(): number;
    get localDataGuardEnabled(): cdktf.IResolvable;
    get location(): string;
    private _longTermBackupSchedule;
    get longTermBackupSchedule(): DataAzurermOracleAutonomousDatabaseCloneFromDatabaseLongTermBackupScheduleList;
    get memoryPerOracleComputeUnitInGb(): number;
    get mtlsConnectionRequired(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nationalCharacterSet(): string;
    get nextLongTermBackupTimestamp(): string;
    get ociUrl(): string;
    get ocid(): string;
    get peerDatabaseIds(): string[];
    get preview(): cdktf.IResolvable;
    get previewVersionWithServiceTermsAccepted(): cdktf.IResolvable;
    get privateEndpointIp(): string;
    get privateEndpointLabel(): string;
    get privateEndpointUrl(): string;
    get provisionableCpus(): number[];
    get reconnectCloneEnabled(): cdktf.IResolvable;
    get refreshableClone(): cdktf.IResolvable;
    get refreshableStatus(): string;
    get remoteDataGuardEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceConsoleUrl(): string;
    get sourceAutonomousDatabaseId(): string;
    get sqlWebDeveloperUrl(): string;
    get subnetId(): string;
    get supportedRegionsToCloneTo(): string[];
    private _tags;
    get tags(): cdktf.StringMap;
    get timeCreatedInUtc(): string;
    get timeDataGuardRoleChangedInUtc(): string;
    get timeDeletionOfFreeAutonomousDatabaseInUtc(): string;
    get timeLocalDataGuardEnabledInUtc(): string;
    get timeMaintenanceBeginInUtc(): string;
    get timeMaintenanceEndInUtc(): string;
    get timeOfLastFailoverInUtc(): string;
    get timeOfLastRefreshInUtc(): string;
    get timeOfLastRefreshPointInUtc(): string;
    get timeOfLastSwitchoverInUtc(): string;
    get timeReclamationOfFreeAutonomousDatabaseInUtc(): string;
    get timeUntilReconnectInUtc(): string;
    get usedDataStorageSizeInGb(): number;
    get usedDataStorageSizeInTb(): number;
    get virtualNetworkId(): string;
    private _timeouts;
    get timeouts(): DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleAutonomousDatabaseCloneFromDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
