/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermOracleExascaleDatabaseStorageVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_exascale_database_storage_vault#id DataAzurermOracleExascaleDatabaseStorageVault#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_exascale_database_storage_vault#name DataAzurermOracleExascaleDatabaseStorageVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_exascale_database_storage_vault#resource_group_name DataAzurermOracleExascaleDatabaseStorageVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_exascale_database_storage_vault#timeouts DataAzurermOracleExascaleDatabaseStorageVault#timeouts}
    */
    readonly timeouts?: DataAzurermOracleExascaleDatabaseStorageVaultTimeouts;
}
export interface DataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage {
}
export declare function dataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageToTerraform(struct?: DataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage): any;
export declare function dataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageToHclTerraform(struct?: DataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage): any;
export declare class DataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage | undefined;
    set internalValue(value: DataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage | undefined);
    get availableSizeInGb(): number;
    get totalSizeInGb(): number;
}
export declare class DataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageOutputReference;
}
export interface DataAzurermOracleExascaleDatabaseStorageVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_exascale_database_storage_vault#read DataAzurermOracleExascaleDatabaseStorageVault#read}
    */
    readonly read?: string;
}
export declare function dataAzurermOracleExascaleDatabaseStorageVaultTimeoutsToTerraform(struct?: DataAzurermOracleExascaleDatabaseStorageVaultTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermOracleExascaleDatabaseStorageVaultTimeoutsToHclTerraform(struct?: DataAzurermOracleExascaleDatabaseStorageVaultTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermOracleExascaleDatabaseStorageVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermOracleExascaleDatabaseStorageVaultTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermOracleExascaleDatabaseStorageVaultTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_exascale_database_storage_vault azurerm_oracle_exascale_database_storage_vault}
*/
export declare class DataAzurermOracleExascaleDatabaseStorageVault extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_oracle_exascale_database_storage_vault";
    /**
    * Generates CDKTF code for importing a DataAzurermOracleExascaleDatabaseStorageVault resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermOracleExascaleDatabaseStorageVault to import
    * @param importFromId The id of the existing DataAzurermOracleExascaleDatabaseStorageVault that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_exascale_database_storage_vault#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermOracleExascaleDatabaseStorageVault to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/oracle_exascale_database_storage_vault azurerm_oracle_exascale_database_storage_vault} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermOracleExascaleDatabaseStorageVaultConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermOracleExascaleDatabaseStorageVaultConfig);
    get additionalFlashCachePercentage(): number;
    get description(): string;
    get displayName(): string;
    private _highCapacityDatabaseStorage;
    get highCapacityDatabaseStorage(): DataAzurermOracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lifecycleDetails(): string;
    get lifecycleState(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get ociUrl(): string;
    get ocid(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get timeZone(): string;
    get virtualMachineClusterCount(): number;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermOracleExascaleDatabaseStorageVaultTimeoutsOutputReference;
    putTimeouts(value: DataAzurermOracleExascaleDatabaseStorageVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermOracleExascaleDatabaseStorageVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
