/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateDnsResolverConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/private_dns_resolver#id DataAzurermPrivateDnsResolver#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/private_dns_resolver#name DataAzurermPrivateDnsResolver#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/private_dns_resolver#resource_group_name DataAzurermPrivateDnsResolver#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/private_dns_resolver#timeouts DataAzurermPrivateDnsResolver#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateDnsResolverTimeouts;
}
export interface DataAzurermPrivateDnsResolverTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/private_dns_resolver#read DataAzurermPrivateDnsResolver#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateDnsResolverTimeoutsToTerraform(struct?: DataAzurermPrivateDnsResolverTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPrivateDnsResolverTimeoutsToHclTerraform(struct?: DataAzurermPrivateDnsResolverTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateDnsResolverTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPrivateDnsResolverTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPrivateDnsResolverTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/private_dns_resolver azurerm_private_dns_resolver}
*/
export declare class DataAzurermPrivateDnsResolver extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_private_dns_resolver";
    /**
    * Generates CDKTF code for importing a DataAzurermPrivateDnsResolver resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPrivateDnsResolver to import
    * @param importFromId The id of the existing DataAzurermPrivateDnsResolver that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/private_dns_resolver#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPrivateDnsResolver to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/private_dns_resolver azurerm_private_dns_resolver} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateDnsResolverConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateDnsResolverConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get virtualNetworkId(): string;
    private _timeouts;
    get timeouts(): DataAzurermPrivateDnsResolverTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateDnsResolverTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPrivateDnsResolverTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
