/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermResourcesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources#id DataAzurermResources#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources#name DataAzurermResources#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources#required_tags DataAzurermResources#required_tags}
    */
    readonly requiredTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources#resource_group_name DataAzurermResources#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources#type DataAzurermResources#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources#timeouts DataAzurermResources#timeouts}
    */
    readonly timeouts?: DataAzurermResourcesTimeouts;
}
export interface DataAzurermResourcesResources {
}
export declare function dataAzurermResourcesResourcesToTerraform(struct?: DataAzurermResourcesResources): any;
export declare function dataAzurermResourcesResourcesToHclTerraform(struct?: DataAzurermResourcesResources): any;
export declare class DataAzurermResourcesResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermResourcesResources | undefined;
    set internalValue(value: DataAzurermResourcesResources | undefined);
    get id(): string;
    get location(): string;
    get name(): string;
    get resourceGroupName(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get type(): string;
}
export declare class DataAzurermResourcesResourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermResourcesResourcesOutputReference;
}
export interface DataAzurermResourcesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources#read DataAzurermResources#read}
    */
    readonly read?: string;
}
export declare function dataAzurermResourcesTimeoutsToTerraform(struct?: DataAzurermResourcesTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermResourcesTimeoutsToHclTerraform(struct?: DataAzurermResourcesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermResourcesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermResourcesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermResourcesTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources azurerm_resources}
*/
export declare class DataAzurermResources extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_resources";
    /**
    * Generates CDKTF code for importing a DataAzurermResources resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermResources to import
    * @param importFromId The id of the existing DataAzurermResources that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermResources to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/resources azurerm_resources} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermResourcesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermResourcesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _requiredTags?;
    get requiredTags(): {
        [key: string]: string;
    };
    set requiredTags(value: {
        [key: string]: string;
    });
    resetRequiredTags(): void;
    get requiredTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _resources;
    get resources(): DataAzurermResourcesResourcesList;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermResourcesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermResourcesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermResourcesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
