/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermServicebusTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic#id DataAzurermServicebusTopic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic#name DataAzurermServicebusTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic#namespace_id DataAzurermServicebusTopic#namespace_id}
    */
    readonly namespaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic#namespace_name DataAzurermServicebusTopic#namespace_name}
    */
    readonly namespaceName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic#resource_group_name DataAzurermServicebusTopic#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic#timeouts DataAzurermServicebusTopic#timeouts}
    */
    readonly timeouts?: DataAzurermServicebusTopicTimeouts;
}
export interface DataAzurermServicebusTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic#read DataAzurermServicebusTopic#read}
    */
    readonly read?: string;
}
export declare function dataAzurermServicebusTopicTimeoutsToTerraform(struct?: DataAzurermServicebusTopicTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermServicebusTopicTimeoutsToHclTerraform(struct?: DataAzurermServicebusTopicTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermServicebusTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermServicebusTopicTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermServicebusTopicTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic azurerm_servicebus_topic}
*/
export declare class DataAzurermServicebusTopic extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_servicebus_topic";
    /**
    * Generates CDKTF code for importing a DataAzurermServicebusTopic resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermServicebusTopic to import
    * @param importFromId The id of the existing DataAzurermServicebusTopic that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermServicebusTopic to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/servicebus_topic azurerm_servicebus_topic} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermServicebusTopicConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusTopicConfig);
    get autoDeleteOnIdle(): string;
    get batchedOperationsEnabled(): cdktf.IResolvable;
    get defaultMessageTtl(): string;
    get duplicateDetectionHistoryTimeWindow(): string;
    get enableBatchedOperations(): cdktf.IResolvable;
    get enableExpress(): cdktf.IResolvable;
    get enablePartitioning(): cdktf.IResolvable;
    get expressEnabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get maxSizeInMegabytes(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceId?;
    get namespaceId(): string;
    set namespaceId(value: string);
    resetNamespaceId(): void;
    get namespaceIdInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    resetNamespaceName(): void;
    get namespaceNameInput(): string | undefined;
    get partitioningEnabled(): cdktf.IResolvable;
    get requiresDuplicateDetection(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    get status(): string;
    get supportOrdering(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermServicebusTopicTimeoutsOutputReference;
    putTimeouts(value: DataAzurermServicebusTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermServicebusTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
