/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSubscriptionTemplateDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/subscription_template_deployment#id DataAzurermSubscriptionTemplateDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/subscription_template_deployment#name DataAzurermSubscriptionTemplateDeployment#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/subscription_template_deployment#timeouts DataAzurermSubscriptionTemplateDeployment#timeouts}
    */
    readonly timeouts?: DataAzurermSubscriptionTemplateDeploymentTimeouts;
}
export interface DataAzurermSubscriptionTemplateDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/subscription_template_deployment#read DataAzurermSubscriptionTemplateDeployment#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSubscriptionTemplateDeploymentTimeoutsToTerraform(struct?: DataAzurermSubscriptionTemplateDeploymentTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSubscriptionTemplateDeploymentTimeoutsToHclTerraform(struct?: DataAzurermSubscriptionTemplateDeploymentTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSubscriptionTemplateDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSubscriptionTemplateDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSubscriptionTemplateDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/subscription_template_deployment azurerm_subscription_template_deployment}
*/
export declare class DataAzurermSubscriptionTemplateDeployment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_subscription_template_deployment";
    /**
    * Generates CDKTF code for importing a DataAzurermSubscriptionTemplateDeployment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSubscriptionTemplateDeployment to import
    * @param importFromId The id of the existing DataAzurermSubscriptionTemplateDeployment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/subscription_template_deployment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSubscriptionTemplateDeployment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/subscription_template_deployment azurerm_subscription_template_deployment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSubscriptionTemplateDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSubscriptionTemplateDeploymentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputContent(): string;
    private _timeouts;
    get timeouts(): DataAzurermSubscriptionTemplateDeploymentTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSubscriptionTemplateDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSubscriptionTemplateDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
