/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermTrafficManagerProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile#id DataAzurermTrafficManagerProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile#name DataAzurermTrafficManagerProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile#resource_group_name DataAzurermTrafficManagerProfile#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile#tags DataAzurermTrafficManagerProfile#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile#traffic_view_enabled DataAzurermTrafficManagerProfile#traffic_view_enabled}
    */
    readonly trafficViewEnabled?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile#timeouts DataAzurermTrafficManagerProfile#timeouts}
    */
    readonly timeouts?: DataAzurermTrafficManagerProfileTimeouts;
}
export interface DataAzurermTrafficManagerProfileDnsConfig {
}
export declare function dataAzurermTrafficManagerProfileDnsConfigToTerraform(struct?: DataAzurermTrafficManagerProfileDnsConfig): any;
export declare function dataAzurermTrafficManagerProfileDnsConfigToHclTerraform(struct?: DataAzurermTrafficManagerProfileDnsConfig): any;
export declare class DataAzurermTrafficManagerProfileDnsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermTrafficManagerProfileDnsConfig | undefined;
    set internalValue(value: DataAzurermTrafficManagerProfileDnsConfig | undefined);
    get relativeName(): string;
    get ttl(): number;
}
export declare class DataAzurermTrafficManagerProfileDnsConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermTrafficManagerProfileDnsConfigOutputReference;
}
export interface DataAzurermTrafficManagerProfileMonitorConfigCustomHeader {
}
export declare function dataAzurermTrafficManagerProfileMonitorConfigCustomHeaderToTerraform(struct?: DataAzurermTrafficManagerProfileMonitorConfigCustomHeader): any;
export declare function dataAzurermTrafficManagerProfileMonitorConfigCustomHeaderToHclTerraform(struct?: DataAzurermTrafficManagerProfileMonitorConfigCustomHeader): any;
export declare class DataAzurermTrafficManagerProfileMonitorConfigCustomHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermTrafficManagerProfileMonitorConfigCustomHeader | undefined;
    set internalValue(value: DataAzurermTrafficManagerProfileMonitorConfigCustomHeader | undefined);
    get name(): string;
    get value(): string;
}
export declare class DataAzurermTrafficManagerProfileMonitorConfigCustomHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermTrafficManagerProfileMonitorConfigCustomHeaderOutputReference;
}
export interface DataAzurermTrafficManagerProfileMonitorConfig {
}
export declare function dataAzurermTrafficManagerProfileMonitorConfigToTerraform(struct?: DataAzurermTrafficManagerProfileMonitorConfig): any;
export declare function dataAzurermTrafficManagerProfileMonitorConfigToHclTerraform(struct?: DataAzurermTrafficManagerProfileMonitorConfig): any;
export declare class DataAzurermTrafficManagerProfileMonitorConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermTrafficManagerProfileMonitorConfig | undefined;
    set internalValue(value: DataAzurermTrafficManagerProfileMonitorConfig | undefined);
    private _customHeader;
    get customHeader(): DataAzurermTrafficManagerProfileMonitorConfigCustomHeaderList;
    get expectedStatusCodeRanges(): string[];
    get intervalInSeconds(): number;
    get path(): string;
    get port(): number;
    get protocol(): string;
    get timeoutInSeconds(): number;
    get toleratedNumberOfFailures(): number;
}
export declare class DataAzurermTrafficManagerProfileMonitorConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermTrafficManagerProfileMonitorConfigOutputReference;
}
export interface DataAzurermTrafficManagerProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile#read DataAzurermTrafficManagerProfile#read}
    */
    readonly read?: string;
}
export declare function dataAzurermTrafficManagerProfileTimeoutsToTerraform(struct?: DataAzurermTrafficManagerProfileTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermTrafficManagerProfileTimeoutsToHclTerraform(struct?: DataAzurermTrafficManagerProfileTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermTrafficManagerProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermTrafficManagerProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermTrafficManagerProfileTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile azurerm_traffic_manager_profile}
*/
export declare class DataAzurermTrafficManagerProfile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_traffic_manager_profile";
    /**
    * Generates CDKTF code for importing a DataAzurermTrafficManagerProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermTrafficManagerProfile to import
    * @param importFromId The id of the existing DataAzurermTrafficManagerProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermTrafficManagerProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/traffic_manager_profile azurerm_traffic_manager_profile} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermTrafficManagerProfileConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermTrafficManagerProfileConfig);
    private _dnsConfig;
    get dnsConfig(): DataAzurermTrafficManagerProfileDnsConfigList;
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _monitorConfig;
    get monitorConfig(): DataAzurermTrafficManagerProfileMonitorConfigList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get profileStatus(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get trafficRoutingMethod(): string;
    private _trafficViewEnabled?;
    get trafficViewEnabled(): boolean | cdktf.IResolvable;
    set trafficViewEnabled(value: boolean | cdktf.IResolvable);
    resetTrafficViewEnabled(): void;
    get trafficViewEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): DataAzurermTrafficManagerProfileTimeoutsOutputReference;
    putTimeouts(value: DataAzurermTrafficManagerProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermTrafficManagerProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
