/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualHubConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_hub_connection#id DataAzurermVirtualHubConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_hub_connection#name DataAzurermVirtualHubConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_hub_connection#resource_group_name DataAzurermVirtualHubConnection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_hub_connection#virtual_hub_name DataAzurermVirtualHubConnection#virtual_hub_name}
    */
    readonly virtualHubName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_hub_connection#timeouts DataAzurermVirtualHubConnection#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualHubConnectionTimeouts;
}
export interface DataAzurermVirtualHubConnectionRoutingPropagatedRouteTable {
}
export declare function dataAzurermVirtualHubConnectionRoutingPropagatedRouteTableToTerraform(struct?: DataAzurermVirtualHubConnectionRoutingPropagatedRouteTable): any;
export declare function dataAzurermVirtualHubConnectionRoutingPropagatedRouteTableToHclTerraform(struct?: DataAzurermVirtualHubConnectionRoutingPropagatedRouteTable): any;
export declare class DataAzurermVirtualHubConnectionRoutingPropagatedRouteTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualHubConnectionRoutingPropagatedRouteTable | undefined;
    set internalValue(value: DataAzurermVirtualHubConnectionRoutingPropagatedRouteTable | undefined);
    get labels(): string[];
    get routeTableIds(): string[];
}
export declare class DataAzurermVirtualHubConnectionRoutingPropagatedRouteTableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualHubConnectionRoutingPropagatedRouteTableOutputReference;
}
export interface DataAzurermVirtualHubConnectionRoutingStaticVnetRoute {
}
export declare function dataAzurermVirtualHubConnectionRoutingStaticVnetRouteToTerraform(struct?: DataAzurermVirtualHubConnectionRoutingStaticVnetRoute): any;
export declare function dataAzurermVirtualHubConnectionRoutingStaticVnetRouteToHclTerraform(struct?: DataAzurermVirtualHubConnectionRoutingStaticVnetRoute): any;
export declare class DataAzurermVirtualHubConnectionRoutingStaticVnetRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualHubConnectionRoutingStaticVnetRoute | undefined;
    set internalValue(value: DataAzurermVirtualHubConnectionRoutingStaticVnetRoute | undefined);
    get addressPrefixes(): string[];
    get name(): string;
    get nextHopIpAddress(): string;
}
export declare class DataAzurermVirtualHubConnectionRoutingStaticVnetRouteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualHubConnectionRoutingStaticVnetRouteOutputReference;
}
export interface DataAzurermVirtualHubConnectionRouting {
}
export declare function dataAzurermVirtualHubConnectionRoutingToTerraform(struct?: DataAzurermVirtualHubConnectionRouting): any;
export declare function dataAzurermVirtualHubConnectionRoutingToHclTerraform(struct?: DataAzurermVirtualHubConnectionRouting): any;
export declare class DataAzurermVirtualHubConnectionRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermVirtualHubConnectionRouting | undefined;
    set internalValue(value: DataAzurermVirtualHubConnectionRouting | undefined);
    get associatedRouteTableId(): string;
    get inboundRouteMapId(): string;
    get outboundRouteMapId(): string;
    private _propagatedRouteTable;
    get propagatedRouteTable(): DataAzurermVirtualHubConnectionRoutingPropagatedRouteTableList;
    get staticVnetLocalRouteOverrideCriteria(): string;
    get staticVnetPropagateStaticRoutesEnabled(): cdktf.IResolvable;
    private _staticVnetRoute;
    get staticVnetRoute(): DataAzurermVirtualHubConnectionRoutingStaticVnetRouteList;
}
export declare class DataAzurermVirtualHubConnectionRoutingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermVirtualHubConnectionRoutingOutputReference;
}
export interface DataAzurermVirtualHubConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_hub_connection#read DataAzurermVirtualHubConnection#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualHubConnectionTimeoutsToTerraform(struct?: DataAzurermVirtualHubConnectionTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermVirtualHubConnectionTimeoutsToHclTerraform(struct?: DataAzurermVirtualHubConnectionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualHubConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualHubConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualHubConnectionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_hub_connection azurerm_virtual_hub_connection}
*/
export declare class DataAzurermVirtualHubConnection extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_hub_connection";
    /**
    * Generates CDKTF code for importing a DataAzurermVirtualHubConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermVirtualHubConnection to import
    * @param importFromId The id of the existing DataAzurermVirtualHubConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_hub_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermVirtualHubConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_hub_connection azurerm_virtual_hub_connection} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualHubConnectionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualHubConnectionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get internetSecurityEnabled(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get remoteVirtualNetworkId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _routing;
    get routing(): DataAzurermVirtualHubConnectionRoutingList;
    get virtualHubId(): string;
    private _virtualHubName?;
    get virtualHubName(): string;
    set virtualHubName(value: string);
    get virtualHubNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermVirtualHubConnectionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualHubConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualHubConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
