/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualWanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_wan#id DataAzurermVirtualWan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_wan#name DataAzurermVirtualWan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_wan#resource_group_name DataAzurermVirtualWan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_wan#timeouts DataAzurermVirtualWan#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualWanTimeouts;
}
export interface DataAzurermVirtualWanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_wan#read DataAzurermVirtualWan#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualWanTimeoutsToTerraform(struct?: DataAzurermVirtualWanTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermVirtualWanTimeoutsToHclTerraform(struct?: DataAzurermVirtualWanTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualWanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualWanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermVirtualWanTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_wan azurerm_virtual_wan}
*/
export declare class DataAzurermVirtualWan extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_wan";
    /**
    * Generates CDKTF code for importing a DataAzurermVirtualWan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermVirtualWan to import
    * @param importFromId The id of the existing DataAzurermVirtualWan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_wan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermVirtualWan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/data-sources/virtual_wan azurerm_virtual_wan} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualWanConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualWanConfig);
    get allowBranchToBranchTraffic(): cdktf.IResolvable;
    get disableVpnEncryption(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get office365LocalBreakoutCategory(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get virtualHubIds(): string[];
    get vpnSiteIds(): string[];
    private _timeouts;
    get timeouts(): DataAzurermVirtualWanTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualWanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermVirtualWanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
