/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElasticSanVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#id ElasticSanVolume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#name ElasticSanVolume#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#size_in_gib ElasticSanVolume#size_in_gib}
    */
    readonly sizeInGib: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#volume_group_id ElasticSanVolume#volume_group_id}
    */
    readonly volumeGroupId: string;
    /**
    * create_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#create_source ElasticSanVolume#create_source}
    */
    readonly createSource?: ElasticSanVolumeCreateSource;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#timeouts ElasticSanVolume#timeouts}
    */
    readonly timeouts?: ElasticSanVolumeTimeouts;
}
export interface ElasticSanVolumeCreateSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#source_id ElasticSanVolume#source_id}
    */
    readonly sourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#source_type ElasticSanVolume#source_type}
    */
    readonly sourceType: string;
}
export declare function elasticSanVolumeCreateSourceToTerraform(struct?: ElasticSanVolumeCreateSourceOutputReference | ElasticSanVolumeCreateSource): any;
export declare function elasticSanVolumeCreateSourceToHclTerraform(struct?: ElasticSanVolumeCreateSourceOutputReference | ElasticSanVolumeCreateSource): any;
export declare class ElasticSanVolumeCreateSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElasticSanVolumeCreateSource | undefined;
    set internalValue(value: ElasticSanVolumeCreateSource | undefined);
    private _sourceId?;
    get sourceId(): string;
    set sourceId(value: string);
    get sourceIdInput(): string | undefined;
    private _sourceType?;
    get sourceType(): string;
    set sourceType(value: string);
    get sourceTypeInput(): string | undefined;
}
export interface ElasticSanVolumeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#create ElasticSanVolume#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#delete ElasticSanVolume#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#read ElasticSanVolume#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#update ElasticSanVolume#update}
    */
    readonly update?: string;
}
export declare function elasticSanVolumeTimeoutsToTerraform(struct?: ElasticSanVolumeTimeouts | cdktf.IResolvable): any;
export declare function elasticSanVolumeTimeoutsToHclTerraform(struct?: ElasticSanVolumeTimeouts | cdktf.IResolvable): any;
export declare class ElasticSanVolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElasticSanVolumeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ElasticSanVolumeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume azurerm_elastic_san_volume}
*/
export declare class ElasticSanVolume extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_elastic_san_volume";
    /**
    * Generates CDKTF code for importing a ElasticSanVolume resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ElasticSanVolume to import
    * @param importFromId The id of the existing ElasticSanVolume that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ElasticSanVolume to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/elastic_san_volume azurerm_elastic_san_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElasticSanVolumeConfig
    */
    constructor(scope: Construct, id: string, config: ElasticSanVolumeConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sizeInGib?;
    get sizeInGib(): number;
    set sizeInGib(value: number);
    get sizeInGibInput(): number | undefined;
    get targetIqn(): string;
    get targetPortalHostname(): string;
    get targetPortalPort(): number;
    private _volumeGroupId?;
    get volumeGroupId(): string;
    set volumeGroupId(value: string);
    get volumeGroupIdInput(): string | undefined;
    get volumeId(): string;
    private _createSource;
    get createSource(): ElasticSanVolumeCreateSourceOutputReference;
    putCreateSource(value: ElasticSanVolumeCreateSource): void;
    resetCreateSource(): void;
    get createSourceInput(): ElasticSanVolumeCreateSource | undefined;
    private _timeouts;
    get timeouts(): ElasticSanVolumeTimeoutsOutputReference;
    putTimeouts(value: ElasticSanVolumeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ElasticSanVolumeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
