/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventgridNamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#capacity EventgridNamespace#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#id EventgridNamespace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#location EventgridNamespace#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#name EventgridNamespace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#public_network_access EventgridNamespace#public_network_access}
    */
    readonly publicNetworkAccess?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#resource_group_name EventgridNamespace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#sku EventgridNamespace#sku}
    */
    readonly sku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#tags EventgridNamespace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#identity EventgridNamespace#identity}
    */
    readonly identity?: EventgridNamespaceIdentity;
    /**
    * inbound_ip_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#inbound_ip_rule EventgridNamespace#inbound_ip_rule}
    */
    readonly inboundIpRule?: EventgridNamespaceInboundIpRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#timeouts EventgridNamespace#timeouts}
    */
    readonly timeouts?: EventgridNamespaceTimeouts;
    /**
    * topic_spaces_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#topic_spaces_configuration EventgridNamespace#topic_spaces_configuration}
    */
    readonly topicSpacesConfiguration?: EventgridNamespaceTopicSpacesConfiguration[] | cdktf.IResolvable;
}
export interface EventgridNamespaceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#identity_ids EventgridNamespace#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#type EventgridNamespace#type}
    */
    readonly type: string;
}
export declare function eventgridNamespaceIdentityToTerraform(struct?: EventgridNamespaceIdentityOutputReference | EventgridNamespaceIdentity): any;
export declare function eventgridNamespaceIdentityToHclTerraform(struct?: EventgridNamespaceIdentityOutputReference | EventgridNamespaceIdentity): any;
export declare class EventgridNamespaceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridNamespaceIdentity | undefined;
    set internalValue(value: EventgridNamespaceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface EventgridNamespaceInboundIpRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#action EventgridNamespace#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#ip_mask EventgridNamespace#ip_mask}
    */
    readonly ipMask: string;
}
export declare function eventgridNamespaceInboundIpRuleToTerraform(struct?: EventgridNamespaceInboundIpRule | cdktf.IResolvable): any;
export declare function eventgridNamespaceInboundIpRuleToHclTerraform(struct?: EventgridNamespaceInboundIpRule | cdktf.IResolvable): any;
export declare class EventgridNamespaceInboundIpRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventgridNamespaceInboundIpRule | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridNamespaceInboundIpRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _ipMask?;
    get ipMask(): string;
    set ipMask(value: string);
    get ipMaskInput(): string | undefined;
}
export declare class EventgridNamespaceInboundIpRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventgridNamespaceInboundIpRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventgridNamespaceInboundIpRuleOutputReference;
}
export interface EventgridNamespaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#create EventgridNamespace#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#delete EventgridNamespace#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#read EventgridNamespace#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#update EventgridNamespace#update}
    */
    readonly update?: string;
}
export declare function eventgridNamespaceTimeoutsToTerraform(struct?: EventgridNamespaceTimeouts | cdktf.IResolvable): any;
export declare function eventgridNamespaceTimeoutsToHclTerraform(struct?: EventgridNamespaceTimeouts | cdktf.IResolvable): any;
export declare class EventgridNamespaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridNamespaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridNamespaceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichment {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#key EventgridNamespace#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#value EventgridNamespace#value}
    */
    readonly value: string;
}
export declare function eventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichmentToTerraform(struct?: EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichment | cdktf.IResolvable): any;
export declare function eventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichmentToHclTerraform(struct?: EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichment | cdktf.IResolvable): any;
export declare class EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichment | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichment | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichmentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichment[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichmentOutputReference;
}
export interface EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichment {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#key EventgridNamespace#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#value EventgridNamespace#value}
    */
    readonly value: string;
}
export declare function eventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichmentToTerraform(struct?: EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichment | cdktf.IResolvable): any;
export declare function eventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichmentToHclTerraform(struct?: EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichment | cdktf.IResolvable): any;
export declare class EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichment | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichment | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichmentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichment[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichmentOutputReference;
}
export interface EventgridNamespaceTopicSpacesConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#alternative_authentication_name_source EventgridNamespace#alternative_authentication_name_source}
    */
    readonly alternativeAuthenticationNameSource?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#maximum_client_sessions_per_authentication_name EventgridNamespace#maximum_client_sessions_per_authentication_name}
    */
    readonly maximumClientSessionsPerAuthenticationName?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#maximum_session_expiry_in_hours EventgridNamespace#maximum_session_expiry_in_hours}
    */
    readonly maximumSessionExpiryInHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#route_topic_id EventgridNamespace#route_topic_id}
    */
    readonly routeTopicId?: string;
    /**
    * dynamic_routing_enrichment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#dynamic_routing_enrichment EventgridNamespace#dynamic_routing_enrichment}
    */
    readonly dynamicRoutingEnrichment?: EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichment[] | cdktf.IResolvable;
    /**
    * static_routing_enrichment block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#static_routing_enrichment EventgridNamespace#static_routing_enrichment}
    */
    readonly staticRoutingEnrichment?: EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichment[] | cdktf.IResolvable;
}
export declare function eventgridNamespaceTopicSpacesConfigurationToTerraform(struct?: EventgridNamespaceTopicSpacesConfiguration | cdktf.IResolvable): any;
export declare function eventgridNamespaceTopicSpacesConfigurationToHclTerraform(struct?: EventgridNamespaceTopicSpacesConfiguration | cdktf.IResolvable): any;
export declare class EventgridNamespaceTopicSpacesConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): EventgridNamespaceTopicSpacesConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridNamespaceTopicSpacesConfiguration | cdktf.IResolvable | undefined);
    private _alternativeAuthenticationNameSource?;
    get alternativeAuthenticationNameSource(): string[];
    set alternativeAuthenticationNameSource(value: string[]);
    resetAlternativeAuthenticationNameSource(): void;
    get alternativeAuthenticationNameSourceInput(): string[] | undefined;
    private _maximumClientSessionsPerAuthenticationName?;
    get maximumClientSessionsPerAuthenticationName(): number;
    set maximumClientSessionsPerAuthenticationName(value: number);
    resetMaximumClientSessionsPerAuthenticationName(): void;
    get maximumClientSessionsPerAuthenticationNameInput(): number | undefined;
    private _maximumSessionExpiryInHours?;
    get maximumSessionExpiryInHours(): number;
    set maximumSessionExpiryInHours(value: number);
    resetMaximumSessionExpiryInHours(): void;
    get maximumSessionExpiryInHoursInput(): number | undefined;
    private _routeTopicId?;
    get routeTopicId(): string;
    set routeTopicId(value: string);
    resetRouteTopicId(): void;
    get routeTopicIdInput(): string | undefined;
    private _dynamicRoutingEnrichment;
    get dynamicRoutingEnrichment(): EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichmentList;
    putDynamicRoutingEnrichment(value: EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichment[] | cdktf.IResolvable): void;
    resetDynamicRoutingEnrichment(): void;
    get dynamicRoutingEnrichmentInput(): cdktf.IResolvable | EventgridNamespaceTopicSpacesConfigurationDynamicRoutingEnrichment[] | undefined;
    private _staticRoutingEnrichment;
    get staticRoutingEnrichment(): EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichmentList;
    putStaticRoutingEnrichment(value: EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichment[] | cdktf.IResolvable): void;
    resetStaticRoutingEnrichment(): void;
    get staticRoutingEnrichmentInput(): cdktf.IResolvable | EventgridNamespaceTopicSpacesConfigurationStaticRoutingEnrichment[] | undefined;
}
export declare class EventgridNamespaceTopicSpacesConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: EventgridNamespaceTopicSpacesConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): EventgridNamespaceTopicSpacesConfigurationOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace azurerm_eventgrid_namespace}
*/
export declare class EventgridNamespace extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_eventgrid_namespace";
    /**
    * Generates CDKTF code for importing a EventgridNamespace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventgridNamespace to import
    * @param importFromId The id of the existing EventgridNamespace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventgridNamespace to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/eventgrid_namespace azurerm_eventgrid_namespace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventgridNamespaceConfig
    */
    constructor(scope: Construct, id: string, config: EventgridNamespaceConfig);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccess?;
    get publicNetworkAccess(): string;
    set publicNetworkAccess(value: string);
    resetPublicNetworkAccess(): void;
    get publicNetworkAccessInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    resetSku(): void;
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): EventgridNamespaceIdentityOutputReference;
    putIdentity(value: EventgridNamespaceIdentity): void;
    resetIdentity(): void;
    get identityInput(): EventgridNamespaceIdentity | undefined;
    private _inboundIpRule;
    get inboundIpRule(): EventgridNamespaceInboundIpRuleList;
    putInboundIpRule(value: EventgridNamespaceInboundIpRule[] | cdktf.IResolvable): void;
    resetInboundIpRule(): void;
    get inboundIpRuleInput(): cdktf.IResolvable | EventgridNamespaceInboundIpRule[] | undefined;
    private _timeouts;
    get timeouts(): EventgridNamespaceTimeoutsOutputReference;
    putTimeouts(value: EventgridNamespaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventgridNamespaceTimeouts | undefined;
    private _topicSpacesConfiguration;
    get topicSpacesConfiguration(): EventgridNamespaceTopicSpacesConfigurationList;
    putTopicSpacesConfiguration(value: EventgridNamespaceTopicSpacesConfiguration[] | cdktf.IResolvable): void;
    resetTopicSpacesConfiguration(): void;
    get topicSpacesConfigurationInput(): cdktf.IResolvable | EventgridNamespaceTopicSpacesConfiguration[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
