/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppIntegrationAccountAssemblyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#assembly_name LogicAppIntegrationAccountAssembly#assembly_name}
    */
    readonly assemblyName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#assembly_version LogicAppIntegrationAccountAssembly#assembly_version}
    */
    readonly assemblyVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#content LogicAppIntegrationAccountAssembly#content}
    */
    readonly content?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#content_link_uri LogicAppIntegrationAccountAssembly#content_link_uri}
    */
    readonly contentLinkUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#id LogicAppIntegrationAccountAssembly#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#integration_account_name LogicAppIntegrationAccountAssembly#integration_account_name}
    */
    readonly integrationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#metadata LogicAppIntegrationAccountAssembly#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#name LogicAppIntegrationAccountAssembly#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#resource_group_name LogicAppIntegrationAccountAssembly#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#timeouts LogicAppIntegrationAccountAssembly#timeouts}
    */
    readonly timeouts?: LogicAppIntegrationAccountAssemblyTimeouts;
}
export interface LogicAppIntegrationAccountAssemblyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#create LogicAppIntegrationAccountAssembly#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#delete LogicAppIntegrationAccountAssembly#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#read LogicAppIntegrationAccountAssembly#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#update LogicAppIntegrationAccountAssembly#update}
    */
    readonly update?: string;
}
export declare function logicAppIntegrationAccountAssemblyTimeoutsToTerraform(struct?: LogicAppIntegrationAccountAssemblyTimeouts | cdktf.IResolvable): any;
export declare function logicAppIntegrationAccountAssemblyTimeoutsToHclTerraform(struct?: LogicAppIntegrationAccountAssemblyTimeouts | cdktf.IResolvable): any;
export declare class LogicAppIntegrationAccountAssemblyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppIntegrationAccountAssemblyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppIntegrationAccountAssemblyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly azurerm_logic_app_integration_account_assembly}
*/
export declare class LogicAppIntegrationAccountAssembly extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_integration_account_assembly";
    /**
    * Generates CDKTF code for importing a LogicAppIntegrationAccountAssembly resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LogicAppIntegrationAccountAssembly to import
    * @param importFromId The id of the existing LogicAppIntegrationAccountAssembly that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LogicAppIntegrationAccountAssembly to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/logic_app_integration_account_assembly azurerm_logic_app_integration_account_assembly} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppIntegrationAccountAssemblyConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppIntegrationAccountAssemblyConfig);
    private _assemblyName?;
    get assemblyName(): string;
    set assemblyName(value: string);
    get assemblyNameInput(): string | undefined;
    private _assemblyVersion?;
    get assemblyVersion(): string;
    set assemblyVersion(value: string);
    resetAssemblyVersion(): void;
    get assemblyVersionInput(): string | undefined;
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    private _contentLinkUri?;
    get contentLinkUri(): string;
    set contentLinkUri(value: string);
    resetContentLinkUri(): void;
    get contentLinkUriInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationAccountName?;
    get integrationAccountName(): string;
    set integrationAccountName(value: string);
    get integrationAccountNameInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): LogicAppIntegrationAccountAssemblyTimeoutsOutputReference;
    putTimeouts(value: LogicAppIntegrationAccountAssemblyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogicAppIntegrationAccountAssemblyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
