/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MachineLearningWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#application_insights_id MachineLearningWorkspace#application_insights_id}
    */
    readonly applicationInsightsId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#container_registry_id MachineLearningWorkspace#container_registry_id}
    */
    readonly containerRegistryId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#description MachineLearningWorkspace#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#friendly_name MachineLearningWorkspace#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#high_business_impact MachineLearningWorkspace#high_business_impact}
    */
    readonly highBusinessImpact?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#id MachineLearningWorkspace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#image_build_compute_name MachineLearningWorkspace#image_build_compute_name}
    */
    readonly imageBuildComputeName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#key_vault_id MachineLearningWorkspace#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#kind MachineLearningWorkspace#kind}
    */
    readonly kind?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#location MachineLearningWorkspace#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#name MachineLearningWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#primary_user_assigned_identity MachineLearningWorkspace#primary_user_assigned_identity}
    */
    readonly primaryUserAssignedIdentity?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#public_network_access_enabled MachineLearningWorkspace#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#resource_group_name MachineLearningWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#service_side_encryption_enabled MachineLearningWorkspace#service_side_encryption_enabled}
    */
    readonly serviceSideEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#sku_name MachineLearningWorkspace#sku_name}
    */
    readonly skuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#storage_account_id MachineLearningWorkspace#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#tags MachineLearningWorkspace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#v1_legacy_mode_enabled MachineLearningWorkspace#v1_legacy_mode_enabled}
    */
    readonly v1LegacyModeEnabled?: boolean | cdktf.IResolvable;
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#encryption MachineLearningWorkspace#encryption}
    */
    readonly encryption?: MachineLearningWorkspaceEncryption;
    /**
    * feature_store block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#feature_store MachineLearningWorkspace#feature_store}
    */
    readonly featureStore?: MachineLearningWorkspaceFeatureStore;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#identity MachineLearningWorkspace#identity}
    */
    readonly identity: MachineLearningWorkspaceIdentity;
    /**
    * managed_network block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#managed_network MachineLearningWorkspace#managed_network}
    */
    readonly managedNetwork?: MachineLearningWorkspaceManagedNetwork;
    /**
    * serverless_compute block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#serverless_compute MachineLearningWorkspace#serverless_compute}
    */
    readonly serverlessCompute?: MachineLearningWorkspaceServerlessCompute;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#timeouts MachineLearningWorkspace#timeouts}
    */
    readonly timeouts?: MachineLearningWorkspaceTimeouts;
}
export interface MachineLearningWorkspaceEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#key_id MachineLearningWorkspace#key_id}
    */
    readonly keyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#key_vault_id MachineLearningWorkspace#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#user_assigned_identity_id MachineLearningWorkspace#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
}
export declare function machineLearningWorkspaceEncryptionToTerraform(struct?: MachineLearningWorkspaceEncryptionOutputReference | MachineLearningWorkspaceEncryption): any;
export declare function machineLearningWorkspaceEncryptionToHclTerraform(struct?: MachineLearningWorkspaceEncryptionOutputReference | MachineLearningWorkspaceEncryption): any;
export declare class MachineLearningWorkspaceEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningWorkspaceEncryption | undefined;
    set internalValue(value: MachineLearningWorkspaceEncryption | undefined);
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    get keyIdInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
}
export interface MachineLearningWorkspaceFeatureStore {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#computer_spark_runtime_version MachineLearningWorkspace#computer_spark_runtime_version}
    */
    readonly computerSparkRuntimeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#offline_connection_name MachineLearningWorkspace#offline_connection_name}
    */
    readonly offlineConnectionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#online_connection_name MachineLearningWorkspace#online_connection_name}
    */
    readonly onlineConnectionName?: string;
}
export declare function machineLearningWorkspaceFeatureStoreToTerraform(struct?: MachineLearningWorkspaceFeatureStoreOutputReference | MachineLearningWorkspaceFeatureStore): any;
export declare function machineLearningWorkspaceFeatureStoreToHclTerraform(struct?: MachineLearningWorkspaceFeatureStoreOutputReference | MachineLearningWorkspaceFeatureStore): any;
export declare class MachineLearningWorkspaceFeatureStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningWorkspaceFeatureStore | undefined;
    set internalValue(value: MachineLearningWorkspaceFeatureStore | undefined);
    private _computerSparkRuntimeVersion?;
    get computerSparkRuntimeVersion(): string;
    set computerSparkRuntimeVersion(value: string);
    resetComputerSparkRuntimeVersion(): void;
    get computerSparkRuntimeVersionInput(): string | undefined;
    private _offlineConnectionName?;
    get offlineConnectionName(): string;
    set offlineConnectionName(value: string);
    resetOfflineConnectionName(): void;
    get offlineConnectionNameInput(): string | undefined;
    private _onlineConnectionName?;
    get onlineConnectionName(): string;
    set onlineConnectionName(value: string);
    resetOnlineConnectionName(): void;
    get onlineConnectionNameInput(): string | undefined;
}
export interface MachineLearningWorkspaceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#identity_ids MachineLearningWorkspace#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#type MachineLearningWorkspace#type}
    */
    readonly type: string;
}
export declare function machineLearningWorkspaceIdentityToTerraform(struct?: MachineLearningWorkspaceIdentityOutputReference | MachineLearningWorkspaceIdentity): any;
export declare function machineLearningWorkspaceIdentityToHclTerraform(struct?: MachineLearningWorkspaceIdentityOutputReference | MachineLearningWorkspaceIdentity): any;
export declare class MachineLearningWorkspaceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningWorkspaceIdentity | undefined;
    set internalValue(value: MachineLearningWorkspaceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MachineLearningWorkspaceManagedNetwork {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#isolation_mode MachineLearningWorkspace#isolation_mode}
    */
    readonly isolationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#provision_on_creation_enabled MachineLearningWorkspace#provision_on_creation_enabled}
    */
    readonly provisionOnCreationEnabled?: boolean | cdktf.IResolvable;
}
export declare function machineLearningWorkspaceManagedNetworkToTerraform(struct?: MachineLearningWorkspaceManagedNetworkOutputReference | MachineLearningWorkspaceManagedNetwork): any;
export declare function machineLearningWorkspaceManagedNetworkToHclTerraform(struct?: MachineLearningWorkspaceManagedNetworkOutputReference | MachineLearningWorkspaceManagedNetwork): any;
export declare class MachineLearningWorkspaceManagedNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningWorkspaceManagedNetwork | undefined;
    set internalValue(value: MachineLearningWorkspaceManagedNetwork | undefined);
    private _isolationMode?;
    get isolationMode(): string;
    set isolationMode(value: string);
    resetIsolationMode(): void;
    get isolationModeInput(): string | undefined;
    private _provisionOnCreationEnabled?;
    get provisionOnCreationEnabled(): boolean | cdktf.IResolvable;
    set provisionOnCreationEnabled(value: boolean | cdktf.IResolvable);
    resetProvisionOnCreationEnabled(): void;
    get provisionOnCreationEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MachineLearningWorkspaceServerlessCompute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#public_ip_enabled MachineLearningWorkspace#public_ip_enabled}
    */
    readonly publicIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#subnet_id MachineLearningWorkspace#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function machineLearningWorkspaceServerlessComputeToTerraform(struct?: MachineLearningWorkspaceServerlessComputeOutputReference | MachineLearningWorkspaceServerlessCompute): any;
export declare function machineLearningWorkspaceServerlessComputeToHclTerraform(struct?: MachineLearningWorkspaceServerlessComputeOutputReference | MachineLearningWorkspaceServerlessCompute): any;
export declare class MachineLearningWorkspaceServerlessComputeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningWorkspaceServerlessCompute | undefined;
    set internalValue(value: MachineLearningWorkspaceServerlessCompute | undefined);
    private _publicIpEnabled?;
    get publicIpEnabled(): boolean | cdktf.IResolvable;
    set publicIpEnabled(value: boolean | cdktf.IResolvable);
    resetPublicIpEnabled(): void;
    get publicIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export interface MachineLearningWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#create MachineLearningWorkspace#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#delete MachineLearningWorkspace#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#read MachineLearningWorkspace#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#update MachineLearningWorkspace#update}
    */
    readonly update?: string;
}
export declare function machineLearningWorkspaceTimeoutsToTerraform(struct?: MachineLearningWorkspaceTimeouts | cdktf.IResolvable): any;
export declare function machineLearningWorkspaceTimeoutsToHclTerraform(struct?: MachineLearningWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class MachineLearningWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningWorkspaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MachineLearningWorkspaceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace azurerm_machine_learning_workspace}
*/
export declare class MachineLearningWorkspace extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_machine_learning_workspace";
    /**
    * Generates CDKTF code for importing a MachineLearningWorkspace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MachineLearningWorkspace to import
    * @param importFromId The id of the existing MachineLearningWorkspace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MachineLearningWorkspace to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/machine_learning_workspace azurerm_machine_learning_workspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MachineLearningWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: MachineLearningWorkspaceConfig);
    private _applicationInsightsId?;
    get applicationInsightsId(): string;
    set applicationInsightsId(value: string);
    get applicationInsightsIdInput(): string | undefined;
    private _containerRegistryId?;
    get containerRegistryId(): string;
    set containerRegistryId(value: string);
    resetContainerRegistryId(): void;
    get containerRegistryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get discoveryUrl(): string;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _highBusinessImpact?;
    get highBusinessImpact(): boolean | cdktf.IResolvable;
    set highBusinessImpact(value: boolean | cdktf.IResolvable);
    resetHighBusinessImpact(): void;
    get highBusinessImpactInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageBuildComputeName?;
    get imageBuildComputeName(): string;
    set imageBuildComputeName(value: string);
    resetImageBuildComputeName(): void;
    get imageBuildComputeNameInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryUserAssignedIdentity?;
    get primaryUserAssignedIdentity(): string;
    set primaryUserAssignedIdentity(value: string);
    resetPrimaryUserAssignedIdentity(): void;
    get primaryUserAssignedIdentityInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceSideEncryptionEnabled?;
    get serviceSideEncryptionEnabled(): boolean | cdktf.IResolvable;
    set serviceSideEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetServiceSideEncryptionEnabled(): void;
    get serviceSideEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    resetSkuName(): void;
    get skuNameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _v1LegacyModeEnabled?;
    get v1LegacyModeEnabled(): boolean | cdktf.IResolvable;
    set v1LegacyModeEnabled(value: boolean | cdktf.IResolvable);
    resetV1LegacyModeEnabled(): void;
    get v1LegacyModeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get workspaceId(): string;
    private _encryption;
    get encryption(): MachineLearningWorkspaceEncryptionOutputReference;
    putEncryption(value: MachineLearningWorkspaceEncryption): void;
    resetEncryption(): void;
    get encryptionInput(): MachineLearningWorkspaceEncryption | undefined;
    private _featureStore;
    get featureStore(): MachineLearningWorkspaceFeatureStoreOutputReference;
    putFeatureStore(value: MachineLearningWorkspaceFeatureStore): void;
    resetFeatureStore(): void;
    get featureStoreInput(): MachineLearningWorkspaceFeatureStore | undefined;
    private _identity;
    get identity(): MachineLearningWorkspaceIdentityOutputReference;
    putIdentity(value: MachineLearningWorkspaceIdentity): void;
    get identityInput(): MachineLearningWorkspaceIdentity | undefined;
    private _managedNetwork;
    get managedNetwork(): MachineLearningWorkspaceManagedNetworkOutputReference;
    putManagedNetwork(value: MachineLearningWorkspaceManagedNetwork): void;
    resetManagedNetwork(): void;
    get managedNetworkInput(): MachineLearningWorkspaceManagedNetwork | undefined;
    private _serverlessCompute;
    get serverlessCompute(): MachineLearningWorkspaceServerlessComputeOutputReference;
    putServerlessCompute(value: MachineLearningWorkspaceServerlessCompute): void;
    resetServerlessCompute(): void;
    get serverlessComputeInput(): MachineLearningWorkspaceServerlessCompute | undefined;
    private _timeouts;
    get timeouts(): MachineLearningWorkspaceTimeoutsOutputReference;
    putTimeouts(value: MachineLearningWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MachineLearningWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
