/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorAlertProcessingRuleSuppressionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#description MonitorAlertProcessingRuleSuppression#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#enabled MonitorAlertProcessingRuleSuppression#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#id MonitorAlertProcessingRuleSuppression#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#name MonitorAlertProcessingRuleSuppression#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#resource_group_name MonitorAlertProcessingRuleSuppression#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#scopes MonitorAlertProcessingRuleSuppression#scopes}
    */
    readonly scopes: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#tags MonitorAlertProcessingRuleSuppression#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#condition MonitorAlertProcessingRuleSuppression#condition}
    */
    readonly condition?: MonitorAlertProcessingRuleSuppressionCondition;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#schedule MonitorAlertProcessingRuleSuppression#schedule}
    */
    readonly schedule?: MonitorAlertProcessingRuleSuppressionSchedule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#timeouts MonitorAlertProcessingRuleSuppression#timeouts}
    */
    readonly timeouts?: MonitorAlertProcessingRuleSuppressionTimeouts;
}
export interface MonitorAlertProcessingRuleSuppressionConditionAlertContext {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionAlertContextToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionAlertContextOutputReference | MonitorAlertProcessingRuleSuppressionConditionAlertContext): any;
export declare function monitorAlertProcessingRuleSuppressionConditionAlertContextToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionAlertContextOutputReference | MonitorAlertProcessingRuleSuppressionConditionAlertContext): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionAlertContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionAlertContext | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionAlertContext | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionAlertRuleId {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionAlertRuleIdToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionAlertRuleIdOutputReference | MonitorAlertProcessingRuleSuppressionConditionAlertRuleId): any;
export declare function monitorAlertProcessingRuleSuppressionConditionAlertRuleIdToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionAlertRuleIdOutputReference | MonitorAlertProcessingRuleSuppressionConditionAlertRuleId): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionAlertRuleIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionAlertRuleId | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionAlertRuleId | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionAlertRuleName {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionAlertRuleNameToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionAlertRuleNameOutputReference | MonitorAlertProcessingRuleSuppressionConditionAlertRuleName): any;
export declare function monitorAlertProcessingRuleSuppressionConditionAlertRuleNameToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionAlertRuleNameOutputReference | MonitorAlertProcessingRuleSuppressionConditionAlertRuleName): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionAlertRuleNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionAlertRuleName | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionAlertRuleName | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionDescription {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionDescriptionToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionDescriptionOutputReference | MonitorAlertProcessingRuleSuppressionConditionDescription): any;
export declare function monitorAlertProcessingRuleSuppressionConditionDescriptionToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionDescriptionOutputReference | MonitorAlertProcessingRuleSuppressionConditionDescription): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionDescription | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionDescription | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionMonitorCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionMonitorConditionToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionMonitorConditionOutputReference | MonitorAlertProcessingRuleSuppressionConditionMonitorCondition): any;
export declare function monitorAlertProcessingRuleSuppressionConditionMonitorConditionToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionMonitorConditionOutputReference | MonitorAlertProcessingRuleSuppressionConditionMonitorCondition): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionMonitorConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionMonitorCondition | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionMonitorCondition | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionMonitorService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionMonitorServiceToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionMonitorServiceOutputReference | MonitorAlertProcessingRuleSuppressionConditionMonitorService): any;
export declare function monitorAlertProcessingRuleSuppressionConditionMonitorServiceToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionMonitorServiceOutputReference | MonitorAlertProcessingRuleSuppressionConditionMonitorService): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionMonitorServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionMonitorService | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionMonitorService | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionSeverity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionSeverityToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionSeverityOutputReference | MonitorAlertProcessingRuleSuppressionConditionSeverity): any;
export declare function monitorAlertProcessingRuleSuppressionConditionSeverityToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionSeverityOutputReference | MonitorAlertProcessingRuleSuppressionConditionSeverity): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionSeverityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionSeverity | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionSeverity | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionSignalType {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionSignalTypeToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionSignalTypeOutputReference | MonitorAlertProcessingRuleSuppressionConditionSignalType): any;
export declare function monitorAlertProcessingRuleSuppressionConditionSignalTypeToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionSignalTypeOutputReference | MonitorAlertProcessingRuleSuppressionConditionSignalType): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionSignalTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionSignalType | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionSignalType | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionTargetResource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionTargetResourceToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionTargetResourceOutputReference | MonitorAlertProcessingRuleSuppressionConditionTargetResource): any;
export declare function monitorAlertProcessingRuleSuppressionConditionTargetResourceToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionTargetResourceOutputReference | MonitorAlertProcessingRuleSuppressionConditionTargetResource): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionTargetResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionTargetResource | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionTargetResource | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroup {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionTargetResourceGroupToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroupOutputReference | MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroup): any;
export declare function monitorAlertProcessingRuleSuppressionConditionTargetResourceGroupToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroupOutputReference | MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroup): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroup | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroup | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionConditionTargetResourceType {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#operator MonitorAlertProcessingRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#values MonitorAlertProcessingRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorAlertProcessingRuleSuppressionConditionTargetResourceTypeToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionTargetResourceTypeOutputReference | MonitorAlertProcessingRuleSuppressionConditionTargetResourceType): any;
export declare function monitorAlertProcessingRuleSuppressionConditionTargetResourceTypeToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionTargetResourceTypeOutputReference | MonitorAlertProcessingRuleSuppressionConditionTargetResourceType): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionTargetResourceTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionConditionTargetResourceType | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionConditionTargetResourceType | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionCondition {
    /**
    * alert_context block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#alert_context MonitorAlertProcessingRuleSuppression#alert_context}
    */
    readonly alertContext?: MonitorAlertProcessingRuleSuppressionConditionAlertContext;
    /**
    * alert_rule_id block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#alert_rule_id MonitorAlertProcessingRuleSuppression#alert_rule_id}
    */
    readonly alertRuleId?: MonitorAlertProcessingRuleSuppressionConditionAlertRuleId;
    /**
    * alert_rule_name block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#alert_rule_name MonitorAlertProcessingRuleSuppression#alert_rule_name}
    */
    readonly alertRuleName?: MonitorAlertProcessingRuleSuppressionConditionAlertRuleName;
    /**
    * description block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#description MonitorAlertProcessingRuleSuppression#description}
    */
    readonly description?: MonitorAlertProcessingRuleSuppressionConditionDescription;
    /**
    * monitor_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#monitor_condition MonitorAlertProcessingRuleSuppression#monitor_condition}
    */
    readonly monitorCondition?: MonitorAlertProcessingRuleSuppressionConditionMonitorCondition;
    /**
    * monitor_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#monitor_service MonitorAlertProcessingRuleSuppression#monitor_service}
    */
    readonly monitorService?: MonitorAlertProcessingRuleSuppressionConditionMonitorService;
    /**
    * severity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#severity MonitorAlertProcessingRuleSuppression#severity}
    */
    readonly severity?: MonitorAlertProcessingRuleSuppressionConditionSeverity;
    /**
    * signal_type block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#signal_type MonitorAlertProcessingRuleSuppression#signal_type}
    */
    readonly signalType?: MonitorAlertProcessingRuleSuppressionConditionSignalType;
    /**
    * target_resource block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#target_resource MonitorAlertProcessingRuleSuppression#target_resource}
    */
    readonly targetResource?: MonitorAlertProcessingRuleSuppressionConditionTargetResource;
    /**
    * target_resource_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#target_resource_group MonitorAlertProcessingRuleSuppression#target_resource_group}
    */
    readonly targetResourceGroup?: MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroup;
    /**
    * target_resource_type block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#target_resource_type MonitorAlertProcessingRuleSuppression#target_resource_type}
    */
    readonly targetResourceType?: MonitorAlertProcessingRuleSuppressionConditionTargetResourceType;
}
export declare function monitorAlertProcessingRuleSuppressionConditionToTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionOutputReference | MonitorAlertProcessingRuleSuppressionCondition): any;
export declare function monitorAlertProcessingRuleSuppressionConditionToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionConditionOutputReference | MonitorAlertProcessingRuleSuppressionCondition): any;
export declare class MonitorAlertProcessingRuleSuppressionConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionCondition | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionCondition | undefined);
    private _alertContext;
    get alertContext(): MonitorAlertProcessingRuleSuppressionConditionAlertContextOutputReference;
    putAlertContext(value: MonitorAlertProcessingRuleSuppressionConditionAlertContext): void;
    resetAlertContext(): void;
    get alertContextInput(): MonitorAlertProcessingRuleSuppressionConditionAlertContext | undefined;
    private _alertRuleId;
    get alertRuleId(): MonitorAlertProcessingRuleSuppressionConditionAlertRuleIdOutputReference;
    putAlertRuleId(value: MonitorAlertProcessingRuleSuppressionConditionAlertRuleId): void;
    resetAlertRuleId(): void;
    get alertRuleIdInput(): MonitorAlertProcessingRuleSuppressionConditionAlertRuleId | undefined;
    private _alertRuleName;
    get alertRuleName(): MonitorAlertProcessingRuleSuppressionConditionAlertRuleNameOutputReference;
    putAlertRuleName(value: MonitorAlertProcessingRuleSuppressionConditionAlertRuleName): void;
    resetAlertRuleName(): void;
    get alertRuleNameInput(): MonitorAlertProcessingRuleSuppressionConditionAlertRuleName | undefined;
    private _description;
    get description(): MonitorAlertProcessingRuleSuppressionConditionDescriptionOutputReference;
    putDescription(value: MonitorAlertProcessingRuleSuppressionConditionDescription): void;
    resetDescription(): void;
    get descriptionInput(): MonitorAlertProcessingRuleSuppressionConditionDescription | undefined;
    private _monitorCondition;
    get monitorCondition(): MonitorAlertProcessingRuleSuppressionConditionMonitorConditionOutputReference;
    putMonitorCondition(value: MonitorAlertProcessingRuleSuppressionConditionMonitorCondition): void;
    resetMonitorCondition(): void;
    get monitorConditionInput(): MonitorAlertProcessingRuleSuppressionConditionMonitorCondition | undefined;
    private _monitorService;
    get monitorService(): MonitorAlertProcessingRuleSuppressionConditionMonitorServiceOutputReference;
    putMonitorService(value: MonitorAlertProcessingRuleSuppressionConditionMonitorService): void;
    resetMonitorService(): void;
    get monitorServiceInput(): MonitorAlertProcessingRuleSuppressionConditionMonitorService | undefined;
    private _severity;
    get severity(): MonitorAlertProcessingRuleSuppressionConditionSeverityOutputReference;
    putSeverity(value: MonitorAlertProcessingRuleSuppressionConditionSeverity): void;
    resetSeverity(): void;
    get severityInput(): MonitorAlertProcessingRuleSuppressionConditionSeverity | undefined;
    private _signalType;
    get signalType(): MonitorAlertProcessingRuleSuppressionConditionSignalTypeOutputReference;
    putSignalType(value: MonitorAlertProcessingRuleSuppressionConditionSignalType): void;
    resetSignalType(): void;
    get signalTypeInput(): MonitorAlertProcessingRuleSuppressionConditionSignalType | undefined;
    private _targetResource;
    get targetResource(): MonitorAlertProcessingRuleSuppressionConditionTargetResourceOutputReference;
    putTargetResource(value: MonitorAlertProcessingRuleSuppressionConditionTargetResource): void;
    resetTargetResource(): void;
    get targetResourceInput(): MonitorAlertProcessingRuleSuppressionConditionTargetResource | undefined;
    private _targetResourceGroup;
    get targetResourceGroup(): MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroupOutputReference;
    putTargetResourceGroup(value: MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroup): void;
    resetTargetResourceGroup(): void;
    get targetResourceGroupInput(): MonitorAlertProcessingRuleSuppressionConditionTargetResourceGroup | undefined;
    private _targetResourceType;
    get targetResourceType(): MonitorAlertProcessingRuleSuppressionConditionTargetResourceTypeOutputReference;
    putTargetResourceType(value: MonitorAlertProcessingRuleSuppressionConditionTargetResourceType): void;
    resetTargetResourceType(): void;
    get targetResourceTypeInput(): MonitorAlertProcessingRuleSuppressionConditionTargetResourceType | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDaily {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#end_time MonitorAlertProcessingRuleSuppression#end_time}
    */
    readonly endTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#start_time MonitorAlertProcessingRuleSuppression#start_time}
    */
    readonly startTime: string;
}
export declare function monitorAlertProcessingRuleSuppressionScheduleRecurrenceDailyToTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDaily | cdktf.IResolvable): any;
export declare function monitorAlertProcessingRuleSuppressionScheduleRecurrenceDailyToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDaily | cdktf.IResolvable): any;
export declare class MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDailyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDaily | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDaily | cdktf.IResolvable | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    get startTimeInput(): string | undefined;
}
export declare class MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDailyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDaily[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDailyOutputReference;
}
export interface MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#days_of_month MonitorAlertProcessingRuleSuppression#days_of_month}
    */
    readonly daysOfMonth: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#end_time MonitorAlertProcessingRuleSuppression#end_time}
    */
    readonly endTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#start_time MonitorAlertProcessingRuleSuppression#start_time}
    */
    readonly startTime?: string;
}
export declare function monitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthlyToTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthly | cdktf.IResolvable): any;
export declare function monitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthlyToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthly | cdktf.IResolvable): any;
export declare class MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthly | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthly | cdktf.IResolvable | undefined);
    private _daysOfMonth?;
    get daysOfMonth(): number[];
    set daysOfMonth(value: number[]);
    get daysOfMonthInput(): number[] | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export declare class MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthlyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthly[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthlyOutputReference;
}
export interface MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeekly {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#days_of_week MonitorAlertProcessingRuleSuppression#days_of_week}
    */
    readonly daysOfWeek: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#end_time MonitorAlertProcessingRuleSuppression#end_time}
    */
    readonly endTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#start_time MonitorAlertProcessingRuleSuppression#start_time}
    */
    readonly startTime?: string;
}
export declare function monitorAlertProcessingRuleSuppressionScheduleRecurrenceWeeklyToTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeekly | cdktf.IResolvable): any;
export declare function monitorAlertProcessingRuleSuppressionScheduleRecurrenceWeeklyToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeekly | cdktf.IResolvable): any;
export declare class MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeekly | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeekly | cdktf.IResolvable | undefined);
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    get daysOfWeekInput(): string[] | undefined;
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export declare class MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeeklyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeekly[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeeklyOutputReference;
}
export interface MonitorAlertProcessingRuleSuppressionScheduleRecurrence {
    /**
    * daily block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#daily MonitorAlertProcessingRuleSuppression#daily}
    */
    readonly daily?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDaily[] | cdktf.IResolvable;
    /**
    * monthly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#monthly MonitorAlertProcessingRuleSuppression#monthly}
    */
    readonly monthly?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthly[] | cdktf.IResolvable;
    /**
    * weekly block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#weekly MonitorAlertProcessingRuleSuppression#weekly}
    */
    readonly weekly?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeekly[] | cdktf.IResolvable;
}
export declare function monitorAlertProcessingRuleSuppressionScheduleRecurrenceToTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceOutputReference | MonitorAlertProcessingRuleSuppressionScheduleRecurrence): any;
export declare function monitorAlertProcessingRuleSuppressionScheduleRecurrenceToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceOutputReference | MonitorAlertProcessingRuleSuppressionScheduleRecurrence): any;
export declare class MonitorAlertProcessingRuleSuppressionScheduleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionScheduleRecurrence | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionScheduleRecurrence | undefined);
    private _daily;
    get daily(): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDailyList;
    putDaily(value: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDaily[] | cdktf.IResolvable): void;
    resetDaily(): void;
    get dailyInput(): cdktf.IResolvable | MonitorAlertProcessingRuleSuppressionScheduleRecurrenceDaily[] | undefined;
    private _monthly;
    get monthly(): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthlyList;
    putMonthly(value: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthly[] | cdktf.IResolvable): void;
    resetMonthly(): void;
    get monthlyInput(): cdktf.IResolvable | MonitorAlertProcessingRuleSuppressionScheduleRecurrenceMonthly[] | undefined;
    private _weekly;
    get weekly(): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeeklyList;
    putWeekly(value: MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeekly[] | cdktf.IResolvable): void;
    resetWeekly(): void;
    get weeklyInput(): cdktf.IResolvable | MonitorAlertProcessingRuleSuppressionScheduleRecurrenceWeekly[] | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#effective_from MonitorAlertProcessingRuleSuppression#effective_from}
    */
    readonly effectiveFrom?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#effective_until MonitorAlertProcessingRuleSuppression#effective_until}
    */
    readonly effectiveUntil?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#time_zone MonitorAlertProcessingRuleSuppression#time_zone}
    */
    readonly timeZone?: string;
    /**
    * recurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#recurrence MonitorAlertProcessingRuleSuppression#recurrence}
    */
    readonly recurrence?: MonitorAlertProcessingRuleSuppressionScheduleRecurrence;
}
export declare function monitorAlertProcessingRuleSuppressionScheduleToTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleOutputReference | MonitorAlertProcessingRuleSuppressionSchedule): any;
export declare function monitorAlertProcessingRuleSuppressionScheduleToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionScheduleOutputReference | MonitorAlertProcessingRuleSuppressionSchedule): any;
export declare class MonitorAlertProcessingRuleSuppressionScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionSchedule | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionSchedule | undefined);
    private _effectiveFrom?;
    get effectiveFrom(): string;
    set effectiveFrom(value: string);
    resetEffectiveFrom(): void;
    get effectiveFromInput(): string | undefined;
    private _effectiveUntil?;
    get effectiveUntil(): string;
    set effectiveUntil(value: string);
    resetEffectiveUntil(): void;
    get effectiveUntilInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _recurrence;
    get recurrence(): MonitorAlertProcessingRuleSuppressionScheduleRecurrenceOutputReference;
    putRecurrence(value: MonitorAlertProcessingRuleSuppressionScheduleRecurrence): void;
    resetRecurrence(): void;
    get recurrenceInput(): MonitorAlertProcessingRuleSuppressionScheduleRecurrence | undefined;
}
export interface MonitorAlertProcessingRuleSuppressionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#create MonitorAlertProcessingRuleSuppression#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#delete MonitorAlertProcessingRuleSuppression#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#read MonitorAlertProcessingRuleSuppression#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#update MonitorAlertProcessingRuleSuppression#update}
    */
    readonly update?: string;
}
export declare function monitorAlertProcessingRuleSuppressionTimeoutsToTerraform(struct?: MonitorAlertProcessingRuleSuppressionTimeouts | cdktf.IResolvable): any;
export declare function monitorAlertProcessingRuleSuppressionTimeoutsToHclTerraform(struct?: MonitorAlertProcessingRuleSuppressionTimeouts | cdktf.IResolvable): any;
export declare class MonitorAlertProcessingRuleSuppressionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAlertProcessingRuleSuppressionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAlertProcessingRuleSuppressionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression azurerm_monitor_alert_processing_rule_suppression}
*/
export declare class MonitorAlertProcessingRuleSuppression extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_alert_processing_rule_suppression";
    /**
    * Generates CDKTF code for importing a MonitorAlertProcessingRuleSuppression resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorAlertProcessingRuleSuppression to import
    * @param importFromId The id of the existing MonitorAlertProcessingRuleSuppression that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorAlertProcessingRuleSuppression to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_alert_processing_rule_suppression azurerm_monitor_alert_processing_rule_suppression} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorAlertProcessingRuleSuppressionConfig
    */
    constructor(scope: Construct, id: string, config: MonitorAlertProcessingRuleSuppressionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    get scopesInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _condition;
    get condition(): MonitorAlertProcessingRuleSuppressionConditionOutputReference;
    putCondition(value: MonitorAlertProcessingRuleSuppressionCondition): void;
    resetCondition(): void;
    get conditionInput(): MonitorAlertProcessingRuleSuppressionCondition | undefined;
    private _schedule;
    get schedule(): MonitorAlertProcessingRuleSuppressionScheduleOutputReference;
    putSchedule(value: MonitorAlertProcessingRuleSuppressionSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): MonitorAlertProcessingRuleSuppressionSchedule | undefined;
    private _timeouts;
    get timeouts(): MonitorAlertProcessingRuleSuppressionTimeoutsOutputReference;
    putTimeouts(value: MonitorAlertProcessingRuleSuppressionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorAlertProcessingRuleSuppressionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
