/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorAutoscaleSettingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#enabled MonitorAutoscaleSetting#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#id MonitorAutoscaleSetting#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#location MonitorAutoscaleSetting#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#name MonitorAutoscaleSetting#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#resource_group_name MonitorAutoscaleSetting#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#tags MonitorAutoscaleSetting#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#target_resource_id MonitorAutoscaleSetting#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * notification block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#notification MonitorAutoscaleSetting#notification}
    */
    readonly notification?: MonitorAutoscaleSettingNotification;
    /**
    * predictive block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#predictive MonitorAutoscaleSetting#predictive}
    */
    readonly predictive?: MonitorAutoscaleSettingPredictive;
    /**
    * profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#profile MonitorAutoscaleSetting#profile}
    */
    readonly profile: MonitorAutoscaleSettingProfile[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#timeouts MonitorAutoscaleSetting#timeouts}
    */
    readonly timeouts?: MonitorAutoscaleSettingTimeouts;
}
export interface MonitorAutoscaleSettingNotificationEmail {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#custom_emails MonitorAutoscaleSetting#custom_emails}
    */
    readonly customEmails?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#send_to_subscription_administrator MonitorAutoscaleSetting#send_to_subscription_administrator}
    */
    readonly sendToSubscriptionAdministrator?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#send_to_subscription_co_administrator MonitorAutoscaleSetting#send_to_subscription_co_administrator}
    */
    readonly sendToSubscriptionCoAdministrator?: boolean | cdktf.IResolvable;
}
export declare function monitorAutoscaleSettingNotificationEmailToTerraform(struct?: MonitorAutoscaleSettingNotificationEmailOutputReference | MonitorAutoscaleSettingNotificationEmail): any;
export declare function monitorAutoscaleSettingNotificationEmailToHclTerraform(struct?: MonitorAutoscaleSettingNotificationEmailOutputReference | MonitorAutoscaleSettingNotificationEmail): any;
export declare class MonitorAutoscaleSettingNotificationEmailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAutoscaleSettingNotificationEmail | undefined;
    set internalValue(value: MonitorAutoscaleSettingNotificationEmail | undefined);
    private _customEmails?;
    get customEmails(): string[];
    set customEmails(value: string[]);
    resetCustomEmails(): void;
    get customEmailsInput(): string[] | undefined;
    private _sendToSubscriptionAdministrator?;
    get sendToSubscriptionAdministrator(): boolean | cdktf.IResolvable;
    set sendToSubscriptionAdministrator(value: boolean | cdktf.IResolvable);
    resetSendToSubscriptionAdministrator(): void;
    get sendToSubscriptionAdministratorInput(): boolean | cdktf.IResolvable | undefined;
    private _sendToSubscriptionCoAdministrator?;
    get sendToSubscriptionCoAdministrator(): boolean | cdktf.IResolvable;
    set sendToSubscriptionCoAdministrator(value: boolean | cdktf.IResolvable);
    resetSendToSubscriptionCoAdministrator(): void;
    get sendToSubscriptionCoAdministratorInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MonitorAutoscaleSettingNotificationWebhook {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#properties MonitorAutoscaleSetting#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#service_uri MonitorAutoscaleSetting#service_uri}
    */
    readonly serviceUri: string;
}
export declare function monitorAutoscaleSettingNotificationWebhookToTerraform(struct?: MonitorAutoscaleSettingNotificationWebhook | cdktf.IResolvable): any;
export declare function monitorAutoscaleSettingNotificationWebhookToHclTerraform(struct?: MonitorAutoscaleSettingNotificationWebhook | cdktf.IResolvable): any;
export declare class MonitorAutoscaleSettingNotificationWebhookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAutoscaleSettingNotificationWebhook | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAutoscaleSettingNotificationWebhook | cdktf.IResolvable | undefined);
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _serviceUri?;
    get serviceUri(): string;
    set serviceUri(value: string);
    get serviceUriInput(): string | undefined;
}
export declare class MonitorAutoscaleSettingNotificationWebhookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAutoscaleSettingNotificationWebhook[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAutoscaleSettingNotificationWebhookOutputReference;
}
export interface MonitorAutoscaleSettingNotification {
    /**
    * email block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#email MonitorAutoscaleSetting#email}
    */
    readonly email?: MonitorAutoscaleSettingNotificationEmail;
    /**
    * webhook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#webhook MonitorAutoscaleSetting#webhook}
    */
    readonly webhook?: MonitorAutoscaleSettingNotificationWebhook[] | cdktf.IResolvable;
}
export declare function monitorAutoscaleSettingNotificationToTerraform(struct?: MonitorAutoscaleSettingNotificationOutputReference | MonitorAutoscaleSettingNotification): any;
export declare function monitorAutoscaleSettingNotificationToHclTerraform(struct?: MonitorAutoscaleSettingNotificationOutputReference | MonitorAutoscaleSettingNotification): any;
export declare class MonitorAutoscaleSettingNotificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAutoscaleSettingNotification | undefined;
    set internalValue(value: MonitorAutoscaleSettingNotification | undefined);
    private _email;
    get email(): MonitorAutoscaleSettingNotificationEmailOutputReference;
    putEmail(value: MonitorAutoscaleSettingNotificationEmail): void;
    resetEmail(): void;
    get emailInput(): MonitorAutoscaleSettingNotificationEmail | undefined;
    private _webhook;
    get webhook(): MonitorAutoscaleSettingNotificationWebhookList;
    putWebhook(value: MonitorAutoscaleSettingNotificationWebhook[] | cdktf.IResolvable): void;
    resetWebhook(): void;
    get webhookInput(): cdktf.IResolvable | MonitorAutoscaleSettingNotificationWebhook[] | undefined;
}
export interface MonitorAutoscaleSettingPredictive {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#look_ahead_time MonitorAutoscaleSetting#look_ahead_time}
    */
    readonly lookAheadTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#scale_mode MonitorAutoscaleSetting#scale_mode}
    */
    readonly scaleMode: string;
}
export declare function monitorAutoscaleSettingPredictiveToTerraform(struct?: MonitorAutoscaleSettingPredictiveOutputReference | MonitorAutoscaleSettingPredictive): any;
export declare function monitorAutoscaleSettingPredictiveToHclTerraform(struct?: MonitorAutoscaleSettingPredictiveOutputReference | MonitorAutoscaleSettingPredictive): any;
export declare class MonitorAutoscaleSettingPredictiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAutoscaleSettingPredictive | undefined;
    set internalValue(value: MonitorAutoscaleSettingPredictive | undefined);
    private _lookAheadTime?;
    get lookAheadTime(): string;
    set lookAheadTime(value: string);
    resetLookAheadTime(): void;
    get lookAheadTimeInput(): string | undefined;
    private _scaleMode?;
    get scaleMode(): string;
    set scaleMode(value: string);
    get scaleModeInput(): string | undefined;
}
export interface MonitorAutoscaleSettingProfileCapacity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#default MonitorAutoscaleSetting#default}
    */
    readonly default: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#maximum MonitorAutoscaleSetting#maximum}
    */
    readonly maximum: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#minimum MonitorAutoscaleSetting#minimum}
    */
    readonly minimum: number;
}
export declare function monitorAutoscaleSettingProfileCapacityToTerraform(struct?: MonitorAutoscaleSettingProfileCapacityOutputReference | MonitorAutoscaleSettingProfileCapacity): any;
export declare function monitorAutoscaleSettingProfileCapacityToHclTerraform(struct?: MonitorAutoscaleSettingProfileCapacityOutputReference | MonitorAutoscaleSettingProfileCapacity): any;
export declare class MonitorAutoscaleSettingProfileCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAutoscaleSettingProfileCapacity | undefined;
    set internalValue(value: MonitorAutoscaleSettingProfileCapacity | undefined);
    private _default?;
    get default(): number;
    set default(value: number);
    get defaultInput(): number | undefined;
    private _maximum?;
    get maximum(): number;
    set maximum(value: number);
    get maximumInput(): number | undefined;
    private _minimum?;
    get minimum(): number;
    set minimum(value: number);
    get minimumInput(): number | undefined;
}
export interface MonitorAutoscaleSettingProfileFixedDate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#end MonitorAutoscaleSetting#end}
    */
    readonly end: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#start MonitorAutoscaleSetting#start}
    */
    readonly start: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#timezone MonitorAutoscaleSetting#timezone}
    */
    readonly timezone?: string;
}
export declare function monitorAutoscaleSettingProfileFixedDateToTerraform(struct?: MonitorAutoscaleSettingProfileFixedDateOutputReference | MonitorAutoscaleSettingProfileFixedDate): any;
export declare function monitorAutoscaleSettingProfileFixedDateToHclTerraform(struct?: MonitorAutoscaleSettingProfileFixedDateOutputReference | MonitorAutoscaleSettingProfileFixedDate): any;
export declare class MonitorAutoscaleSettingProfileFixedDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAutoscaleSettingProfileFixedDate | undefined;
    set internalValue(value: MonitorAutoscaleSettingProfileFixedDate | undefined);
    private _end?;
    get end(): string;
    set end(value: string);
    get endInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    get startInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
}
export interface MonitorAutoscaleSettingProfileRecurrence {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#days MonitorAutoscaleSetting#days}
    */
    readonly days: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#hours MonitorAutoscaleSetting#hours}
    */
    readonly hours: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#minutes MonitorAutoscaleSetting#minutes}
    */
    readonly minutes: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#timezone MonitorAutoscaleSetting#timezone}
    */
    readonly timezone?: string;
}
export declare function monitorAutoscaleSettingProfileRecurrenceToTerraform(struct?: MonitorAutoscaleSettingProfileRecurrenceOutputReference | MonitorAutoscaleSettingProfileRecurrence): any;
export declare function monitorAutoscaleSettingProfileRecurrenceToHclTerraform(struct?: MonitorAutoscaleSettingProfileRecurrenceOutputReference | MonitorAutoscaleSettingProfileRecurrence): any;
export declare class MonitorAutoscaleSettingProfileRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAutoscaleSettingProfileRecurrence | undefined;
    set internalValue(value: MonitorAutoscaleSettingProfileRecurrence | undefined);
    private _days?;
    get days(): string[];
    set days(value: string[]);
    get daysInput(): string[] | undefined;
    private _hours?;
    get hours(): number[];
    set hours(value: number[]);
    get hoursInput(): number[] | undefined;
    private _minutes?;
    get minutes(): number[];
    set minutes(value: number[]);
    get minutesInput(): number[] | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
}
export interface MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#name MonitorAutoscaleSetting#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#operator MonitorAutoscaleSetting#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#values MonitorAutoscaleSetting#values}
    */
    readonly values: string[];
}
export declare function monitorAutoscaleSettingProfileRuleMetricTriggerDimensionsToTerraform(struct?: MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions | cdktf.IResolvable): any;
export declare function monitorAutoscaleSettingProfileRuleMetricTriggerDimensionsToHclTerraform(struct?: MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions | cdktf.IResolvable): any;
export declare class MonitorAutoscaleSettingProfileRuleMetricTriggerDimensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class MonitorAutoscaleSettingProfileRuleMetricTriggerDimensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAutoscaleSettingProfileRuleMetricTriggerDimensionsOutputReference;
}
export interface MonitorAutoscaleSettingProfileRuleMetricTrigger {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#divide_by_instance_count MonitorAutoscaleSetting#divide_by_instance_count}
    */
    readonly divideByInstanceCount?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#metric_name MonitorAutoscaleSetting#metric_name}
    */
    readonly metricName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#metric_namespace MonitorAutoscaleSetting#metric_namespace}
    */
    readonly metricNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#metric_resource_id MonitorAutoscaleSetting#metric_resource_id}
    */
    readonly metricResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#operator MonitorAutoscaleSetting#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#statistic MonitorAutoscaleSetting#statistic}
    */
    readonly statistic: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#threshold MonitorAutoscaleSetting#threshold}
    */
    readonly threshold: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#time_aggregation MonitorAutoscaleSetting#time_aggregation}
    */
    readonly timeAggregation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#time_grain MonitorAutoscaleSetting#time_grain}
    */
    readonly timeGrain: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#time_window MonitorAutoscaleSetting#time_window}
    */
    readonly timeWindow: string;
    /**
    * dimensions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#dimensions MonitorAutoscaleSetting#dimensions}
    */
    readonly dimensions?: MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions[] | cdktf.IResolvable;
}
export declare function monitorAutoscaleSettingProfileRuleMetricTriggerToTerraform(struct?: MonitorAutoscaleSettingProfileRuleMetricTriggerOutputReference | MonitorAutoscaleSettingProfileRuleMetricTrigger): any;
export declare function monitorAutoscaleSettingProfileRuleMetricTriggerToHclTerraform(struct?: MonitorAutoscaleSettingProfileRuleMetricTriggerOutputReference | MonitorAutoscaleSettingProfileRuleMetricTrigger): any;
export declare class MonitorAutoscaleSettingProfileRuleMetricTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAutoscaleSettingProfileRuleMetricTrigger | undefined;
    set internalValue(value: MonitorAutoscaleSettingProfileRuleMetricTrigger | undefined);
    private _divideByInstanceCount?;
    get divideByInstanceCount(): boolean | cdktf.IResolvable;
    set divideByInstanceCount(value: boolean | cdktf.IResolvable);
    resetDivideByInstanceCount(): void;
    get divideByInstanceCountInput(): boolean | cdktf.IResolvable | undefined;
    private _metricName?;
    get metricName(): string;
    set metricName(value: string);
    get metricNameInput(): string | undefined;
    private _metricNamespace?;
    get metricNamespace(): string;
    set metricNamespace(value: string);
    resetMetricNamespace(): void;
    get metricNamespaceInput(): string | undefined;
    private _metricResourceId?;
    get metricResourceId(): string;
    set metricResourceId(value: string);
    get metricResourceIdInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _statistic?;
    get statistic(): string;
    set statistic(value: string);
    get statisticInput(): string | undefined;
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
    private _timeAggregation?;
    get timeAggregation(): string;
    set timeAggregation(value: string);
    get timeAggregationInput(): string | undefined;
    private _timeGrain?;
    get timeGrain(): string;
    set timeGrain(value: string);
    get timeGrainInput(): string | undefined;
    private _timeWindow?;
    get timeWindow(): string;
    set timeWindow(value: string);
    get timeWindowInput(): string | undefined;
    private _dimensions;
    get dimensions(): MonitorAutoscaleSettingProfileRuleMetricTriggerDimensionsList;
    putDimensions(value: MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions[] | cdktf.IResolvable): void;
    resetDimensions(): void;
    get dimensionsInput(): cdktf.IResolvable | MonitorAutoscaleSettingProfileRuleMetricTriggerDimensions[] | undefined;
}
export interface MonitorAutoscaleSettingProfileRuleScaleAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#cooldown MonitorAutoscaleSetting#cooldown}
    */
    readonly cooldown: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#direction MonitorAutoscaleSetting#direction}
    */
    readonly direction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#type MonitorAutoscaleSetting#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#value MonitorAutoscaleSetting#value}
    */
    readonly value: number;
}
export declare function monitorAutoscaleSettingProfileRuleScaleActionToTerraform(struct?: MonitorAutoscaleSettingProfileRuleScaleActionOutputReference | MonitorAutoscaleSettingProfileRuleScaleAction): any;
export declare function monitorAutoscaleSettingProfileRuleScaleActionToHclTerraform(struct?: MonitorAutoscaleSettingProfileRuleScaleActionOutputReference | MonitorAutoscaleSettingProfileRuleScaleAction): any;
export declare class MonitorAutoscaleSettingProfileRuleScaleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAutoscaleSettingProfileRuleScaleAction | undefined;
    set internalValue(value: MonitorAutoscaleSettingProfileRuleScaleAction | undefined);
    private _cooldown?;
    get cooldown(): string;
    set cooldown(value: string);
    get cooldownInput(): string | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface MonitorAutoscaleSettingProfileRule {
    /**
    * metric_trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#metric_trigger MonitorAutoscaleSetting#metric_trigger}
    */
    readonly metricTrigger: MonitorAutoscaleSettingProfileRuleMetricTrigger;
    /**
    * scale_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#scale_action MonitorAutoscaleSetting#scale_action}
    */
    readonly scaleAction: MonitorAutoscaleSettingProfileRuleScaleAction;
}
export declare function monitorAutoscaleSettingProfileRuleToTerraform(struct?: MonitorAutoscaleSettingProfileRule | cdktf.IResolvable): any;
export declare function monitorAutoscaleSettingProfileRuleToHclTerraform(struct?: MonitorAutoscaleSettingProfileRule | cdktf.IResolvable): any;
export declare class MonitorAutoscaleSettingProfileRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAutoscaleSettingProfileRule | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAutoscaleSettingProfileRule | cdktf.IResolvable | undefined);
    private _metricTrigger;
    get metricTrigger(): MonitorAutoscaleSettingProfileRuleMetricTriggerOutputReference;
    putMetricTrigger(value: MonitorAutoscaleSettingProfileRuleMetricTrigger): void;
    get metricTriggerInput(): MonitorAutoscaleSettingProfileRuleMetricTrigger | undefined;
    private _scaleAction;
    get scaleAction(): MonitorAutoscaleSettingProfileRuleScaleActionOutputReference;
    putScaleAction(value: MonitorAutoscaleSettingProfileRuleScaleAction): void;
    get scaleActionInput(): MonitorAutoscaleSettingProfileRuleScaleAction | undefined;
}
export declare class MonitorAutoscaleSettingProfileRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAutoscaleSettingProfileRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAutoscaleSettingProfileRuleOutputReference;
}
export interface MonitorAutoscaleSettingProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#name MonitorAutoscaleSetting#name}
    */
    readonly name: string;
    /**
    * capacity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#capacity MonitorAutoscaleSetting#capacity}
    */
    readonly capacity: MonitorAutoscaleSettingProfileCapacity;
    /**
    * fixed_date block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#fixed_date MonitorAutoscaleSetting#fixed_date}
    */
    readonly fixedDate?: MonitorAutoscaleSettingProfileFixedDate;
    /**
    * recurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#recurrence MonitorAutoscaleSetting#recurrence}
    */
    readonly recurrence?: MonitorAutoscaleSettingProfileRecurrence;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#rule MonitorAutoscaleSetting#rule}
    */
    readonly rule?: MonitorAutoscaleSettingProfileRule[] | cdktf.IResolvable;
}
export declare function monitorAutoscaleSettingProfileToTerraform(struct?: MonitorAutoscaleSettingProfile | cdktf.IResolvable): any;
export declare function monitorAutoscaleSettingProfileToHclTerraform(struct?: MonitorAutoscaleSettingProfile | cdktf.IResolvable): any;
export declare class MonitorAutoscaleSettingProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MonitorAutoscaleSettingProfile | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAutoscaleSettingProfile | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _capacity;
    get capacity(): MonitorAutoscaleSettingProfileCapacityOutputReference;
    putCapacity(value: MonitorAutoscaleSettingProfileCapacity): void;
    get capacityInput(): MonitorAutoscaleSettingProfileCapacity | undefined;
    private _fixedDate;
    get fixedDate(): MonitorAutoscaleSettingProfileFixedDateOutputReference;
    putFixedDate(value: MonitorAutoscaleSettingProfileFixedDate): void;
    resetFixedDate(): void;
    get fixedDateInput(): MonitorAutoscaleSettingProfileFixedDate | undefined;
    private _recurrence;
    get recurrence(): MonitorAutoscaleSettingProfileRecurrenceOutputReference;
    putRecurrence(value: MonitorAutoscaleSettingProfileRecurrence): void;
    resetRecurrence(): void;
    get recurrenceInput(): MonitorAutoscaleSettingProfileRecurrence | undefined;
    private _rule;
    get rule(): MonitorAutoscaleSettingProfileRuleList;
    putRule(value: MonitorAutoscaleSettingProfileRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | MonitorAutoscaleSettingProfileRule[] | undefined;
}
export declare class MonitorAutoscaleSettingProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MonitorAutoscaleSettingProfile[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MonitorAutoscaleSettingProfileOutputReference;
}
export interface MonitorAutoscaleSettingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#create MonitorAutoscaleSetting#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#delete MonitorAutoscaleSetting#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#read MonitorAutoscaleSetting#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#update MonitorAutoscaleSetting#update}
    */
    readonly update?: string;
}
export declare function monitorAutoscaleSettingTimeoutsToTerraform(struct?: MonitorAutoscaleSettingTimeouts | cdktf.IResolvable): any;
export declare function monitorAutoscaleSettingTimeoutsToHclTerraform(struct?: MonitorAutoscaleSettingTimeouts | cdktf.IResolvable): any;
export declare class MonitorAutoscaleSettingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorAutoscaleSettingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorAutoscaleSettingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting azurerm_monitor_autoscale_setting}
*/
export declare class MonitorAutoscaleSetting extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_autoscale_setting";
    /**
    * Generates CDKTF code for importing a MonitorAutoscaleSetting resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorAutoscaleSetting to import
    * @param importFromId The id of the existing MonitorAutoscaleSetting that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorAutoscaleSetting to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_autoscale_setting azurerm_monitor_autoscale_setting} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorAutoscaleSettingConfig
    */
    constructor(scope: Construct, id: string, config: MonitorAutoscaleSettingConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _notification;
    get notification(): MonitorAutoscaleSettingNotificationOutputReference;
    putNotification(value: MonitorAutoscaleSettingNotification): void;
    resetNotification(): void;
    get notificationInput(): MonitorAutoscaleSettingNotification | undefined;
    private _predictive;
    get predictive(): MonitorAutoscaleSettingPredictiveOutputReference;
    putPredictive(value: MonitorAutoscaleSettingPredictive): void;
    resetPredictive(): void;
    get predictiveInput(): MonitorAutoscaleSettingPredictive | undefined;
    private _profile;
    get profile(): MonitorAutoscaleSettingProfileList;
    putProfile(value: MonitorAutoscaleSettingProfile[] | cdktf.IResolvable): void;
    get profileInput(): cdktf.IResolvable | MonitorAutoscaleSettingProfile[] | undefined;
    private _timeouts;
    get timeouts(): MonitorAutoscaleSettingTimeoutsOutputReference;
    putTimeouts(value: MonitorAutoscaleSettingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorAutoscaleSettingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
