/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorPrivateLinkScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#id MonitorPrivateLinkScope#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#ingestion_access_mode MonitorPrivateLinkScope#ingestion_access_mode}
    */
    readonly ingestionAccessMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#name MonitorPrivateLinkScope#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#query_access_mode MonitorPrivateLinkScope#query_access_mode}
    */
    readonly queryAccessMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#resource_group_name MonitorPrivateLinkScope#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#tags MonitorPrivateLinkScope#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#timeouts MonitorPrivateLinkScope#timeouts}
    */
    readonly timeouts?: MonitorPrivateLinkScopeTimeouts;
}
export interface MonitorPrivateLinkScopeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#create MonitorPrivateLinkScope#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#delete MonitorPrivateLinkScope#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#read MonitorPrivateLinkScope#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#update MonitorPrivateLinkScope#update}
    */
    readonly update?: string;
}
export declare function monitorPrivateLinkScopeTimeoutsToTerraform(struct?: MonitorPrivateLinkScopeTimeouts | cdktf.IResolvable): any;
export declare function monitorPrivateLinkScopeTimeoutsToHclTerraform(struct?: MonitorPrivateLinkScopeTimeouts | cdktf.IResolvable): any;
export declare class MonitorPrivateLinkScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorPrivateLinkScopeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorPrivateLinkScopeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope azurerm_monitor_private_link_scope}
*/
export declare class MonitorPrivateLinkScope extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_private_link_scope";
    /**
    * Generates CDKTF code for importing a MonitorPrivateLinkScope resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MonitorPrivateLinkScope to import
    * @param importFromId The id of the existing MonitorPrivateLinkScope that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MonitorPrivateLinkScope to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/monitor_private_link_scope azurerm_monitor_private_link_scope} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorPrivateLinkScopeConfig
    */
    constructor(scope: Construct, id: string, config: MonitorPrivateLinkScopeConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ingestionAccessMode?;
    get ingestionAccessMode(): string;
    set ingestionAccessMode(value: string);
    resetIngestionAccessMode(): void;
    get ingestionAccessModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queryAccessMode?;
    get queryAccessMode(): string;
    set queryAccessMode(value: string);
    resetQueryAccessMode(): void;
    get queryAccessModeInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): MonitorPrivateLinkScopeTimeoutsOutputReference;
    putTimeouts(value: MonitorPrivateLinkScopeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorPrivateLinkScopeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
