/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetappAccountEncryptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full resource ID of the cross-tenant key vault. Required when using federated_client_id for cross-tenant scenarios.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#cross_tenant_key_vault_resource_id NetappAccountEncryption#cross_tenant_key_vault_resource_id}
    */
    readonly crossTenantKeyVaultResourceId?: string;
    /**
    * The versionless encryption key url.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#encryption_key NetappAccountEncryption#encryption_key}
    */
    readonly encryptionKey: string;
    /**
    * The Client ID of the multi-tenant Entra ID application used to access cross-tenant key vaults.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#federated_client_id NetappAccountEncryption#federated_client_id}
    */
    readonly federatedClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#id NetappAccountEncryption#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the NetApp Account where encryption will be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#netapp_account_id NetappAccountEncryption#netapp_account_id}
    */
    readonly netappAccountId: string;
    /**
    * The Principal ID of the System Assigned Identity to use for encryption.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#system_assigned_identity_principal_id NetappAccountEncryption#system_assigned_identity_principal_id}
    */
    readonly systemAssignedIdentityPrincipalId?: string;
    /**
    * The resource ID of the User Assigned Identity to use for encryption.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#user_assigned_identity_id NetappAccountEncryption#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#timeouts NetappAccountEncryption#timeouts}
    */
    readonly timeouts?: NetappAccountEncryptionTimeouts;
}
export interface NetappAccountEncryptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#create NetappAccountEncryption#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#delete NetappAccountEncryption#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#read NetappAccountEncryption#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#update NetappAccountEncryption#update}
    */
    readonly update?: string;
}
export declare function netappAccountEncryptionTimeoutsToTerraform(struct?: NetappAccountEncryptionTimeouts | cdktf.IResolvable): any;
export declare function netappAccountEncryptionTimeoutsToHclTerraform(struct?: NetappAccountEncryptionTimeouts | cdktf.IResolvable): any;
export declare class NetappAccountEncryptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappAccountEncryptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetappAccountEncryptionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption azurerm_netapp_account_encryption}
*/
export declare class NetappAccountEncryption extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_netapp_account_encryption";
    /**
    * Generates CDKTF code for importing a NetappAccountEncryption resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetappAccountEncryption to import
    * @param importFromId The id of the existing NetappAccountEncryption that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetappAccountEncryption to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/netapp_account_encryption azurerm_netapp_account_encryption} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetappAccountEncryptionConfig
    */
    constructor(scope: Construct, id: string, config: NetappAccountEncryptionConfig);
    private _crossTenantKeyVaultResourceId?;
    get crossTenantKeyVaultResourceId(): string;
    set crossTenantKeyVaultResourceId(value: string);
    resetCrossTenantKeyVaultResourceId(): void;
    get crossTenantKeyVaultResourceIdInput(): string | undefined;
    private _encryptionKey?;
    get encryptionKey(): string;
    set encryptionKey(value: string);
    get encryptionKeyInput(): string | undefined;
    private _federatedClientId?;
    get federatedClientId(): string;
    set federatedClientId(value: string);
    resetFederatedClientId(): void;
    get federatedClientIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _netappAccountId?;
    get netappAccountId(): string;
    set netappAccountId(value: string);
    get netappAccountIdInput(): string | undefined;
    private _systemAssignedIdentityPrincipalId?;
    get systemAssignedIdentityPrincipalId(): string;
    set systemAssignedIdentityPrincipalId(value: string);
    resetSystemAssignedIdentityPrincipalId(): void;
    get systemAssignedIdentityPrincipalIdInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetappAccountEncryptionTimeoutsOutputReference;
    putTimeouts(value: NetappAccountEncryptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetappAccountEncryptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
