/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkManagerRoutingRuleCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#bgp_route_propagation_enabled NetworkManagerRoutingRuleCollection#bgp_route_propagation_enabled}
    */
    readonly bgpRoutePropagationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#description NetworkManagerRoutingRuleCollection#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#id NetworkManagerRoutingRuleCollection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#name NetworkManagerRoutingRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#network_group_ids NetworkManagerRoutingRuleCollection#network_group_ids}
    */
    readonly networkGroupIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#routing_configuration_id NetworkManagerRoutingRuleCollection#routing_configuration_id}
    */
    readonly routingConfigurationId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#timeouts NetworkManagerRoutingRuleCollection#timeouts}
    */
    readonly timeouts?: NetworkManagerRoutingRuleCollectionTimeouts;
}
export interface NetworkManagerRoutingRuleCollectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#create NetworkManagerRoutingRuleCollection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#delete NetworkManagerRoutingRuleCollection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#read NetworkManagerRoutingRuleCollection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#update NetworkManagerRoutingRuleCollection#update}
    */
    readonly update?: string;
}
export declare function networkManagerRoutingRuleCollectionTimeoutsToTerraform(struct?: NetworkManagerRoutingRuleCollectionTimeouts | cdktf.IResolvable): any;
export declare function networkManagerRoutingRuleCollectionTimeoutsToHclTerraform(struct?: NetworkManagerRoutingRuleCollectionTimeouts | cdktf.IResolvable): any;
export declare class NetworkManagerRoutingRuleCollectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerRoutingRuleCollectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerRoutingRuleCollectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection azurerm_network_manager_routing_rule_collection}
*/
export declare class NetworkManagerRoutingRuleCollection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_manager_routing_rule_collection";
    /**
    * Generates CDKTF code for importing a NetworkManagerRoutingRuleCollection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkManagerRoutingRuleCollection to import
    * @param importFromId The id of the existing NetworkManagerRoutingRuleCollection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkManagerRoutingRuleCollection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_routing_rule_collection azurerm_network_manager_routing_rule_collection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkManagerRoutingRuleCollectionConfig
    */
    constructor(scope: Construct, id: string, config: NetworkManagerRoutingRuleCollectionConfig);
    private _bgpRoutePropagationEnabled?;
    get bgpRoutePropagationEnabled(): boolean | cdktf.IResolvable;
    set bgpRoutePropagationEnabled(value: boolean | cdktf.IResolvable);
    resetBgpRoutePropagationEnabled(): void;
    get bgpRoutePropagationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkGroupIds?;
    get networkGroupIds(): string[];
    set networkGroupIds(value: string[]);
    get networkGroupIdsInput(): string[] | undefined;
    private _routingConfigurationId?;
    get routingConfigurationId(): string;
    set routingConfigurationId(value: string);
    get routingConfigurationIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkManagerRoutingRuleCollectionTimeoutsOutputReference;
    putTimeouts(value: NetworkManagerRoutingRuleCollectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkManagerRoutingRuleCollectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
