/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#description NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#destination_resource_id NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#destination_resource_id}
    */
    readonly destinationResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#id NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#name NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#source_resource_id NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#source_resource_id}
    */
    readonly sourceResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#verifier_workspace_id NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#verifier_workspace_id}
    */
    readonly verifierWorkspaceId: string;
    /**
    * ip_traffic block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#ip_traffic NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#ip_traffic}
    */
    readonly ipTraffic: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTraffic;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#timeouts NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#timeouts}
    */
    readonly timeouts?: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeouts;
}
export interface NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTraffic {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#destination_ips NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#destination_ips}
    */
    readonly destinationIps: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#destination_ports NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#destination_ports}
    */
    readonly destinationPorts: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#protocols NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#protocols}
    */
    readonly protocols: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#source_ips NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#source_ips}
    */
    readonly sourceIps: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#source_ports NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#source_ports}
    */
    readonly sourcePorts: string[];
}
export declare function networkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficToTerraform(struct?: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficOutputReference | NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTraffic): any;
export declare function networkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficToHclTerraform(struct?: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficOutputReference | NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTraffic): any;
export declare class NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTraffic | undefined;
    set internalValue(value: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTraffic | undefined);
    private _destinationIps?;
    get destinationIps(): string[];
    set destinationIps(value: string[]);
    get destinationIpsInput(): string[] | undefined;
    private _destinationPorts?;
    get destinationPorts(): string[];
    set destinationPorts(value: string[]);
    get destinationPortsInput(): string[] | undefined;
    private _protocols?;
    get protocols(): string[];
    set protocols(value: string[]);
    get protocolsInput(): string[] | undefined;
    private _sourceIps?;
    get sourceIps(): string[];
    set sourceIps(value: string[]);
    get sourceIpsInput(): string[] | undefined;
    private _sourcePorts?;
    get sourcePorts(): string[];
    set sourcePorts(value: string[]);
    get sourcePortsInput(): string[] | undefined;
}
export interface NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#create NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#delete NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#read NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent#read}
    */
    readonly read?: string;
}
export declare function networkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeoutsToTerraform(struct?: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeouts | cdktf.IResolvable): any;
export declare function networkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeoutsToHclTerraform(struct?: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeouts | cdktf.IResolvable): any;
export declare class NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent azurerm_network_manager_verifier_workspace_reachability_analysis_intent}
*/
export declare class NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_manager_verifier_workspace_reachability_analysis_intent";
    /**
    * Generates CDKTF code for importing a NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent to import
    * @param importFromId The id of the existing NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkManagerVerifierWorkspaceReachabilityAnalysisIntent to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/network_manager_verifier_workspace_reachability_analysis_intent azurerm_network_manager_verifier_workspace_reachability_analysis_intent} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentConfig
    */
    constructor(scope: Construct, id: string, config: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationResourceId?;
    get destinationResourceId(): string;
    set destinationResourceId(value: string);
    get destinationResourceIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sourceResourceId?;
    get sourceResourceId(): string;
    set sourceResourceId(value: string);
    get sourceResourceIdInput(): string | undefined;
    private _verifierWorkspaceId?;
    get verifierWorkspaceId(): string;
    set verifierWorkspaceId(value: string);
    get verifierWorkspaceIdInput(): string | undefined;
    private _ipTraffic;
    get ipTraffic(): NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTrafficOutputReference;
    putIpTraffic(value: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTraffic): void;
    get ipTrafficInput(): NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentIpTraffic | undefined;
    private _timeouts;
    get timeouts(): NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeoutsOutputReference;
    putTimeouts(value: NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkManagerVerifierWorkspaceReachabilityAnalysisIntentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
