/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OracleExascaleDatabaseStorageVaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#additional_flash_cache_percentage OracleExascaleDatabaseStorageVault#additional_flash_cache_percentage}
    */
    readonly additionalFlashCachePercentage: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#description OracleExascaleDatabaseStorageVault#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#display_name OracleExascaleDatabaseStorageVault#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#id OracleExascaleDatabaseStorageVault#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#location OracleExascaleDatabaseStorageVault#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#name OracleExascaleDatabaseStorageVault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#resource_group_name OracleExascaleDatabaseStorageVault#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#tags OracleExascaleDatabaseStorageVault#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#time_zone OracleExascaleDatabaseStorageVault#time_zone}
    */
    readonly timeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#zones OracleExascaleDatabaseStorageVault#zones}
    */
    readonly zones: string[];
    /**
    * high_capacity_database_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#high_capacity_database_storage OracleExascaleDatabaseStorageVault#high_capacity_database_storage}
    */
    readonly highCapacityDatabaseStorage: OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#timeouts OracleExascaleDatabaseStorageVault#timeouts}
    */
    readonly timeouts?: OracleExascaleDatabaseStorageVaultTimeouts;
}
export interface OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#total_size_in_gb OracleExascaleDatabaseStorageVault#total_size_in_gb}
    */
    readonly totalSizeInGb: number;
}
export declare function oracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageToTerraform(struct?: OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageOutputReference | OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage): any;
export declare function oracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageToHclTerraform(struct?: OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageOutputReference | OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage): any;
export declare class OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage | undefined;
    set internalValue(value: OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage | undefined);
    get availableSizeInGb(): number;
    private _totalSizeInGb?;
    get totalSizeInGb(): number;
    set totalSizeInGb(value: number);
    get totalSizeInGbInput(): number | undefined;
}
export interface OracleExascaleDatabaseStorageVaultTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#create OracleExascaleDatabaseStorageVault#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#delete OracleExascaleDatabaseStorageVault#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#read OracleExascaleDatabaseStorageVault#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#update OracleExascaleDatabaseStorageVault#update}
    */
    readonly update?: string;
}
export declare function oracleExascaleDatabaseStorageVaultTimeoutsToTerraform(struct?: OracleExascaleDatabaseStorageVaultTimeouts | cdktf.IResolvable): any;
export declare function oracleExascaleDatabaseStorageVaultTimeoutsToHclTerraform(struct?: OracleExascaleDatabaseStorageVaultTimeouts | cdktf.IResolvable): any;
export declare class OracleExascaleDatabaseStorageVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OracleExascaleDatabaseStorageVaultTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OracleExascaleDatabaseStorageVaultTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault azurerm_oracle_exascale_database_storage_vault}
*/
export declare class OracleExascaleDatabaseStorageVault extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_oracle_exascale_database_storage_vault";
    /**
    * Generates CDKTF code for importing a OracleExascaleDatabaseStorageVault resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OracleExascaleDatabaseStorageVault to import
    * @param importFromId The id of the existing OracleExascaleDatabaseStorageVault that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OracleExascaleDatabaseStorageVault to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.49.0/docs/resources/oracle_exascale_database_storage_vault azurerm_oracle_exascale_database_storage_vault} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OracleExascaleDatabaseStorageVaultConfig
    */
    constructor(scope: Construct, id: string, config: OracleExascaleDatabaseStorageVaultConfig);
    private _additionalFlashCachePercentage?;
    get additionalFlashCachePercentage(): number;
    set additionalFlashCachePercentage(value: number);
    get additionalFlashCachePercentageInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    get zonesInput(): string[] | undefined;
    private _highCapacityDatabaseStorage;
    get highCapacityDatabaseStorage(): OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorageOutputReference;
    putHighCapacityDatabaseStorage(value: OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage): void;
    get highCapacityDatabaseStorageInput(): OracleExascaleDatabaseStorageVaultHighCapacityDatabaseStorage | undefined;
    private _timeouts;
    get timeouts(): OracleExascaleDatabaseStorageVaultTimeoutsOutputReference;
    putTimeouts(value: OracleExascaleDatabaseStorageVaultTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OracleExascaleDatabaseStorageVaultTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
